//https://www.geeksforgeeks.org/shortest-path-unweighted-graph/

#include <bits/stdc++.h> 
using namespace std;  
  
void add_edge(vector<int> adj[], int src, int dest) 
{ 
    adj[src].push_back(dest); 
    adj[dest].push_back(src); 
} 
  
bool BFS(vector<int> adj[], int src, int dest, int v, 
                            int pred[], int dist[]) 
{ 

    list<int> queue; 
    bool visited[v]; 
  
    for (int i = 0; i < v; i++) { 
        visited[i] = false; 
        dist[i] = INT_MAX; 
        pred[i] = -1; 
    } 
  
    visited[src] = true; 
    dist[src] = 0; 
    queue.push_back(src); 
  
    while (!queue.empty()) { 
        int u = queue.front(); 
        queue.pop_front(); 
        for (int i = 0; i < adj[u].size(); i++) { 
            if (visited[adj[u][i]] == false) { 
                visited[adj[u][i]] = true; 
                dist[adj[u][i]] = dist[u] + 1; 
                pred[adj[u][i]] = u; 
                queue.push_back(adj[u][i]); 
  
                if (adj[u][i] == dest) 
                   return true; 
            } 
        } 
    } 
  
    return false; 
} 
  
int printShortestDistance(vector<int> adj[], int s,  
                                    int dest, int v) 
{ 
    int pred[v], dist[v]; 
  
    if (BFS(adj, s, dest, v, pred, dist) == false) 
    { 
        cout << "Given source and destination"
             << " are not connected"; 
        return dist[dest]; 
    } 
  
    vector<int> path; 
    int crawl = dest; 
    path.push_back(crawl); 
    while (pred[crawl] != -1) { 
        path.push_back(pred[crawl]); 
        crawl = pred[crawl]; 
    } 
  
	return dist[dest]; 
} 
  
int main() 
{ 
    int n, u, v, maxDist = INT_MIN, currDist;
    cin >> n;  
  
    vector<int> adj[n];
    vector<pair<int, int> > sizes;
    vector<int> igrac1; 

	for (int i = 0; i < n - 1; ++i) {
		cin >> u >> v;
		add_edge(adj, u-1, v-1);
	}
	
	for (int i = 0; i < n; ++i) {
		sizes.emplace_back(make_pair(adj[i].size(), i));
	}
	
	sort(sizes.begin(), sizes.end());
	
	for (int i = n - 1; i >= 0; --i) {
		if (i % 2 == 0) {
			igrac1.emplace_back(sizes[i].second);
		}
	}
	
	for (int i = 0; i < igrac1.size() - 1; ++i) {
		for (int j = i + 1; j < igrac1.size(); ++j) {
			currDist = printShortestDistance(adj, igrac1[i], igrac1[j], n);
			maxDist = (currDist > maxDist) ? currDist : maxDist; 
		}
	}
	
	cout << maxDist;
	
}