#include <iostream>
#include <cstdio>
#include <algorithm>

using namespace std;

int* read(int n) {
	int* t = new int[n];
	for (int i = 0; i < n; i++)
		scanf("%d", t + i);
	return t;
}

void print(int n, int *t) {
	for (int i = 0; i < n; i++)
		printf("%d ", t[i]);
}

int* generateAscending(int n) {
	int* t = new int[n];
	for (int i = 0; i < n; i++)
		t[i] = i;
	return t;
}

void sort(int p, int q, int* x, int* t) {
	int i = p, j = q, pivot = x[t[p]];
	while (i <= j) {
		for (; x[t[i]] > pivot; i++);
		for (; x[t[j]] < pivot; j--);
		if (i <= j) {
			if (x[t[i]] < x[t[j]] || t[i] < t[j])
				swap(t[i], t[j]);
			i++;
			j--;
		}
	}

	if (i < q)
		sort(i, q, x, t);
	if (j > p)
		sort(p, j, x, t);
}

int main() {
	int n;
	cin >> n;

	int* x = read(n);
	int* t = generateAscending(n);
	sort(0, n - 1, x, t);

	int k;
	for (k = 0; k < n && x[k] == x[t[k]]; k++);
	if (k >= n) {
		swap(x[0], x[1]);
	}
	else {
		swap(x[k], x[t[k]]);
	}
	print(n, x);

	delete[] x;
	delete[] t;
	return 0;
}