#include <iostream>

int part(int* arr, int start, int end) {
	int pivot = arr[end];
	
	int index = start;
	int temp;
	
	for(int i = start; i < end; i++) {
		if(arr[i] >= pivot) {
			temp = arr[i];
			arr[i] = arr[index];
			arr[index] = temp;
			index++;
		}
	}
	
	temp = arr[end];
	arr[end] = arr[index];
	arr[index] = temp;
	
	return index;
};

void sort(int* arr, int start, int end) {
	if (start < end) {
		int i = part(arr, start, end);
		sort(arr, start, i - 1);
		sort(arr, i + 1, end);
	}
}

int main(int argc, char* argv[]) {
	
    int n; // broj knjiga na polici
	std::cin >> n;
	int arr[n]; // brojevi
	for(int i = 0; i < n; i++) {
		int element;
		std::cin >> element;
		
		arr[i] = element;
	}
	
	sort(arr, 0, n - 1);
	for (int i = 0; i < n; i++) {
		std::cout << arr[i] << " ";
	}
	
    return 0;
}