#include <iostream>
#include <vector>
#include <unordered_map>
#include <map>
#include <unordered_set>
#include <algorithm>
using namespace std;

unordered_map<int, vector<int>> graf;
unordered_map<int, int> udaljenost;
map<int, vector<int>> duzine_stabala;
unordered_set<int> poseceni;
unordered_set<int> uzeo_prvi;
int najveca_dubina = -1;
int najdublji_cvor = -1;

void dfs(int cvor, int dubina)
{
	poseceni.insert(cvor);
	vector<int> susedi = graf[cvor];
	for (auto i = susedi.begin(); i != susedi.end(); i++)
	{
		if(poseceni.find(*i) == poseceni.end())
			dfs(*i, dubina + 1);
	}
	if (dubina > najveca_dubina)
	{
		najveca_dubina = dubina;
		najdublji_cvor = cvor;
	}
}

void dfs_resenje(int cvor, int dubina)
{
	poseceni.insert(cvor);
	vector<int> susedi = graf[cvor];
	for (auto i = susedi.begin(); i != susedi.end(); i++)
	{
		if (poseceni.find(*i) == poseceni.end())
			dfs_resenje(*i, dubina + 1);
	}
	if (dubina > najveca_dubina && uzeo_prvi.find(cvor) != uzeo_prvi.end())
	{
		najveca_dubina = dubina;
		najdublji_cvor = cvor;
	}
}

void dfs_racunaj_udaljenosti(int cvor, int dubina)
{
	poseceni.insert(cvor);
	vector<int> susedi = graf[cvor];
	for (auto i = susedi.begin(); i != susedi.end(); i++)
	{
		if (poseceni.find(*i) == poseceni.end())
		{
			udaljenost[*i] = dubina + 1;
			dfs_racunaj_udaljenosti(*i, dubina + 1);
		}
	}
	if (dubina > najveca_dubina)
	{
		najveca_dubina = dubina;
		najdublji_cvor = cvor;
	}
}

int main()
{
	int n;
	cin >> n;
	for (int i = 0; i < n - 1; i++)
	{
		int cvor1, cvor2;
		cin >> cvor1;
		cin >> cvor2;
		graf[cvor1].push_back(cvor2);
		graf[cvor2].push_back(cvor1);
	}

	dfs(1, 0);
	int najdublji_cvor1 = najdublji_cvor;
	najveca_dubina = -1;
	najdublji_cvor = -1;
	poseceni.clear();
	dfs_racunaj_udaljenosti(najdublji_cvor1, 0);
	int najdublji_cvor2 = najdublji_cvor;
	najveca_dubina = -1;
	najdublji_cvor = -1;
	poseceni.clear();
	unordered_map<int, int> udaljenost1 = udaljenost;
	udaljenost.clear();
	dfs_racunaj_udaljenosti(najdublji_cvor2, 0);
	najveca_dubina = -1;
	najdublji_cvor = -1;
	poseceni.clear();
	unordered_map<int, int> udaljenost2 = udaljenost;

	for (int i = 1; i <= n; i++)
	{
		duzine_stabala[max(udaljenost1[i], udaljenost2[i])].push_back(i);
	}

	int k = 0;
	for (auto i = duzine_stabala.begin(); i != duzine_stabala.end(); i++)
	{
		vector<int> cvorovi_duzine = (*i).second;
		for(int j = 0; j < cvorovi_duzine.size(); j++)
		{
			if(k % 2 == 0)
				uzeo_prvi.insert(cvorovi_duzine[j]);
			k++;
		}
	}
	
	dfs_resenje(*(uzeo_prvi.begin()), 0);
	int najdublji_cvor1_resenje = najdublji_cvor;
	najveca_dubina = -1;
	najdublji_cvor = -1;
	poseceni.clear();
	dfs_resenje(najdublji_cvor1_resenje, 0);
	cout << najveca_dubina;
	
	return 0;
}