#include <bits/stdc++.h>

using namespace std;


typedef pair<int, int> pii;
typedef priority_queue<pii> pqpi;
typedef set<pii> spi;
typedef vector<pii> vpi;
typedef long double T;
typedef vector<T> vt;


#define EB emplace_back
#define MP make_pair
#define F first
#define S second


// global variables:
int H, W, R;
pqpi CIRCLES_LEFT, CIRCLES_RIGHT;

// Simple version:
vt MEMO_X;
spi OLD_CIRCLES;


// functions:
void Eat(int x_circle, int y_circle);
T Calculate(int x_rect, int x_circle_center, int y_circle_center);
vpi getCirclesInRange(int x_rect);

void SolveSimple();
void InsertSimple(int x, int y);


void displayQueue(pqpi q) {
    printf("Queue:\n");
    while(!q.empty()) {
        printf("O(%d, %d), ", q.top().F, q.top().S);
        q.pop();
    }
    printf("\n");
}


int main()
{
    //freopen("input.txt", "r", stdin);

    int q;
    scanf("%d %d %d %d\n", &W, &H, &R, &q);

    MEMO_X.assign(W, -1);

    bool goSimple = false;
    if (8 * R <= q) goSimple = true;

    int x, y, cmd;
    while(q--) {
        scanf("%d ", &cmd);
        switch (cmd) {
            case 1:
                scanf("%d %d", &x, &y);
                if (goSimple) {
                    InsertSimple(x, y);
                } else {
                    Eat(x, y);
                }
                break;
            default:
                scanf("%d", &x);
                if (goSimple) {  // this solution in total: O(Q * R):
                    if (MEMO_X[x] < 0) {
                        printf("%d\n", H);
                        break;
                    }
                    if (H <= MEMO_X[x]) {
                        printf("%d\n", H);
                        break;
                    }
                    cout << setprecision(11) << MEMO_X[x] << "\n";
                    break;
                }  // O((Q^2) / 4)
                vpi circles_to_calc = getCirclesInRange(x);  // only distinct circles in range

                // if there was no circle in xi +- R range found:
                // print the H
                if (circles_to_calc.size() == 0) {
                    printf("%d\n", H);
                    break;
                }

                T y_rect = Calculate(x, circles_to_calc[0].F, circles_to_calc[0].S);
                for (int i = 1, n = circles_to_calc.size(); i < n; ++i) {
                    y_rect = min(y_rect, Calculate(x, circles_to_calc[i].F, circles_to_calc[i].S));
                }

                cout << setprecision(11) << y_rect << "\n";
                break;
        }
    }

    return 0;
}


void SolveSimple() {

}

void InsertSimple(int x, int y) {
    int old_size = OLD_CIRCLES.size();
    OLD_CIRCLES.insert(MP(x, y));
    if (old_size == OLD_CIRCLES.size()) return;

    for (int x_rect = max(0, x - R); x_rect <= R; ++x_rect) {
        if (MEMO_X[x_rect] < 0) {
            MEMO_X[x_rect] = Calculate(x_rect, x, y);
            continue;
        }
        MEMO_X[x_rect] = min(MEMO_X[x_rect], Calculate(x_rect, x, y));
    }
}


vpi getCirclesInRange(int x_rect) {
    spi out;
    vpi final_out;

    pqpi circ_left_copy = CIRCLES_LEFT;
    pqpi circ_right_copy = CIRCLES_RIGHT;

    /*displayQueue(circ_left_copy);
    displayQueue(circ_right_copy);*/

    int j = circ_left_copy.size();
    int limit = j / 2;

    if (!j) return final_out;

    bool is_left_insert_allowed = false;
    bool is_right_insert_allowed = false;

    j--;
    while(j >= limit) {
        pii left_cur = MP((-1) * circ_left_copy.top().F, (-1) * circ_left_copy.top().S);
        pii right_cur = circ_right_copy.top();

        /*printf("Left cur to check: (%d, %d)\n", left_cur.F, left_cur.S);
        printf("Right cur to check: (%d, %d)\n", right_cur.F, right_cur.S);*/

        int out_old_size = out.size();

        if (!is_left_insert_allowed && left_cur.F > x_rect - R && left_cur.F < x_rect + R) {
            is_left_insert_allowed = true;

            //printf("HEY: left_cur.F: %d, Epsilon Right: %d, x: %d\n", left_cur.F, x_rect + R, x_rect);

        }

        if (is_left_insert_allowed) {
            // make sure not to take the same element twice
            out.insert(left_cur);
            if (out_old_size != out.size()) {
                out_old_size++;
                final_out.EB(left_cur);
            }
        }

        if (!is_right_insert_allowed && right_cur.F < x_rect + R && right_cur.F > x_rect - R) {
            is_right_insert_allowed = true;
        }

        if (is_right_insert_allowed) {
            out.insert(right_cur);
            if (out_old_size != out.size()) {
                out_old_size++;
                final_out.EB(right_cur);
            }
        }

        circ_left_copy.pop();
        circ_right_copy.pop();
        --j;
    }


    return final_out;
}


void Eat(int x_circle, int y_circle) {
    // if it does not intersect with rectangle ignore it:
    if (y_circle - R >= H) return;
    // store the circle in a sorted array (sorted by X)
    CIRCLES_RIGHT.push(MP(x_circle, y_circle));
    CIRCLES_LEFT.push(MP(-1 * x_circle, -1 * y_circle));  // for easier lookup
}

T Calculate(int x_rect, int x_circle_center, int y_circle_center) {
    T y_rect = 1.0 * y_circle_center - sqrt((R - x_rect + x_circle_center) * (R + x_rect - x_circle_center));
    /*printf("Calculated: O(%d, %d) in %d ", x_circle_center, y_circle_center, x_rect);
    cout << setprecision(11) << y_rect << "\n";*/
    return y_rect;
}