#include <bits/stdc++.h>

using namespace std;


typedef vector<int> vi;


// global variables:
int N;
vi BOOKS;


// functions:
void input();
void Solve();
void output(vi vct);


int main()
{
    //freopen("input.txt", "r", stdin);

    input();
    Solve();

    return 0;
}


void Solve() {
    if (N == 2) {  // handle simplest case
        printf("%d %d\n", BOOKS[1], BOOKS[0]);
        return;
    }

    const int memo_length = 10;
    vi digits_memo(memo_length);  // stores each digit's # of occurrences

    for (int i = 0; i < N; ++i) {
        ++digits_memo[BOOKS[i]];
    }

    int max_digit = memo_length - 1;
    int first_digit = -1;  // digit to swap with max digit
    bool is_finishing_swap = false;  // keep track of whether one element was already swapped

    for (int i = 0; i < N; ++i) {
        if (is_finishing_swap) {
            if (BOOKS[i] == max_digit) {
                if (!digits_memo[max_digit]) {  // reached last occurrence of max digit in BOOKS
                    BOOKS[i] = first_digit;
                    break;
                }
                --digits_memo[max_digit];  // update # of max digit left to check
            }
            continue;
        }
        // find max unchecked digit in BOOKS
        while (max_digit >= 0 && !digits_memo[max_digit]) {
            max_digit--;
        }
        // check if it should be swapped with max digit on its right
        if (BOOKS[i] < max_digit) {
            first_digit = BOOKS[i];
            BOOKS[i] = max_digit;
            is_finishing_swap = true;
        }
        --digits_memo[max_digit];
    }

    if (!is_finishing_swap) {  // digits in BOOKS were in non-increasing order
        swap(BOOKS[N - 2], BOOKS[N - 1]);
    }

    output(BOOKS);
}


void output(vi vct) {
    for (auto it = vct.begin(); it != vct.end(); ++it) {
        printf("%d ", (*it));
    }
    printf("\n");
}


void input() {
    scanf("%d\n", &N);

    BOOKS.resize(N);  // reallocate memory

    for (int i = 0; i < N; ++i) {
        scanf("%d", &BOOKS[i]);
    }
}