#include <bits/stdc++.h>

using namespace std;


typedef vector<int> vi;
typedef long long ll;


// global variables:
int N;
vi ROW_MEMO, COL_MEMO;  // Store number of coins in each row/col


// functions:
void input();
void Solve();

bool isSolved();
ll arithmeticSum(int n, int a_n);  // each el increased by 1
ll calculateChangesInDimension(vi vct);


int main()
{
    //freopen("input.txt", "r", stdin);

    input();
    Solve();

    return 0;
}



void Solve() {
    if (isSolved()) {
        printf("0\n");
        return;
    }

    ll time = 0LL;

    time = calculateChangesInDimension(ROW_MEMO) + calculateChangesInDimension(COL_MEMO);

    printf("%lld\n", time);
}


ll calculateChangesInDimension(vi vct) {
    ll time = 0LL;

    int zero_start = -1;
    int last_non_zero_val = -1;
    for (int i = N - 1; i >= 0; --i) {
        if (!vct[i]) {  // cur element is 0
            if (zero_start < 0) zero_start = i;
            continue;
        }

        int zero_streak_len = zero_start - i;
        // check if last element can add more value to current one
        if (last_non_zero_val > 1) {
            if (zero_start < 0) {  // two non 0 values are next to each other
                vct[i] += last_non_zero_val - 1;
                time += last_non_zero_val - 1;
            } else {
                int step_to_next_non_zero_val = last_non_zero_val - zero_streak_len - 1;
                if (step_to_next_non_zero_val > 0) {
                    zero_start = -1;
                    vct[i] += step_to_next_non_zero_val;
                } else if (step_to_next_non_zero_val == 0){
                    zero_start = -1;
                } else {  // it is not enough to fill them out
                    zero_start -= last_non_zero_val;
                }
                int num_of_zeros_to_change = min(last_non_zero_val - 1, zero_streak_len);
                time += arithmeticSum(num_of_zeros_to_change, num_of_zeros_to_change) + max(0, step_to_next_non_zero_val * (zero_streak_len + 1));
            }
        }
        last_non_zero_val = vct[i];

        if (zero_start < 0) continue;

        // cur el is not enough to fill the whole gap:
        if (last_non_zero_val <= zero_streak_len) {
            time += arithmeticSum(last_non_zero_val, zero_streak_len);
            // update values:
            zero_start -= last_non_zero_val;
            last_non_zero_val = 0;
        } else {
            time += arithmeticSum(zero_streak_len, zero_streak_len);
            // update values:
            last_non_zero_val -= zero_streak_len;
            zero_start = -1;  // streak of zeros stops
        }
    }

    if (zero_start != -1) {  // array starts with 0
        int zero_streak_len = zero_start + 1;
        time += arithmeticSum(zero_streak_len, zero_streak_len);
    }

    return time;
}


ll arithmeticSum(int n, int a_n) {
    ll cur_sum = a_n - n + 1 + a_n;
    ll sum = (n * cur_sum) / 2;
    return sum;
}


bool isSolved() {
    for (int i = 0; i < N; ++i) {
        // if there is an unfulfilled row/column
        // task is not solved
        if (!ROW_MEMO[i] || !COL_MEMO[i]) return false;
    }
    return true;
}


void input() {
    scanf("%d\n", &N);

    // reallocate space and assign zeros:
    ROW_MEMO.resize(N);
    COL_MEMO.resize(N);

    int cur_row, cur_col;
    for (int i = 0; i < N; ++i) {
        scanf("%d %d", &cur_row, &cur_col);
        ++ROW_MEMO[cur_row - 1];
        ++COL_MEMO[cur_col - 1];
    }
}