#include <iostream>
#include <cmath>


using namespace std;

void addArray(long arr[], long n) {
    for (long i = 0; i < n; i++) {
        arr[i] = i + 1;
    }
}

void switchPositions(long* a, long* b)
{
    long t = *a;
    *a = *b;
    *b = t;
}

long divider(long arr[], long low, long high)
{
    long pivot = arr[high];
    long i = low - 1;

    for (long j = low; j <= high - 1; j++) {
        if (arr[j] < pivot) {
            i += 1;
            switchPositions(&arr[i], &arr[j]);
        }
    }
    switchPositions(&arr[i + 1], &arr[high]);
    return i + 1;
}

void quickSort(long arr[], long low, long high)
{
    if (low < high) {
        long pi = divider(arr, low, high);

        quickSort(arr, low, pi - 1);
        quickSort(arr, pi + 1, high);
    }
}

long compare(long arr[], long original[], int n) {
    long steps = 0;
    for (long i = 0; i < n; i++) {
        steps += abs(arr[i] - original[i]);
    }

    return steps;
}

int main() {

    long n;
    cin >> n;

    long columns[n] = {};
    long rows[n] = {};

    for (long i = 0; i < n; i++) {
        long ri, ci;
        cin >> ri >> ci;

        rows[i] = ri;
        columns[i] = ci;
    }

    long updatedC[n], updatedR[n];
    addArray(updatedC, n);
    addArray(updatedR, n);

    quickSort(columns, 0, n - 1);
    quickSort(rows, 0, n - 1);

    long total = compare(rows, updatedR, n) + compare(columns, updatedC, n);
    cout << total;
    return 0;
}