using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
namespace JAG
{
    class Cvor
    {
        public int podatak;
        public Grana grane;
        public Cvor sledeci;
        public int status;
        public double duzinaPuta;
        public Cvor prethodni;
        public Cvor()
        {
            grane = null; sledeci = null; status = 0;
        }
        public Cvor(int podatak)
        {
            this.podatak = podatak;
        }
        public Cvor(int podatak, Grana grane, Cvor sledeci, int status)
        {
            this.podatak = podatak; this.grane = grane; this.sledeci = sledeci; this.status = status;
        }
        public void prikazi(bool bStatus = false)
        {
            if (bStatus)
            {
                Console.WriteLine(podatak.ToString() + " " + status);
            }
            else
            {
                Console.WriteLine(podatak.ToString());
            }
        }
    };

    partial class Grana
    {
        public Cvor odrediste;
        public Grana sledeca;
        public double tezina;
        public Grana()
        {
        }
        public Grana(Cvor odrediste, Grana sledeca)
        {
            this.odrediste = odrediste; this.sledeca = sledeca;
        }
        public Grana(Cvor odrediste, Grana sledeca, double tezina)
        {
            this.odrediste = odrediste; this.sledeca = sledeca; this.tezina = tezina;
        }
    };

    partial class Graf
    {
        protected Cvor cvorovi;
        protected long brojCvorova;
        public long GetBrojCvorova()
        {
            return brojCvorova;
        }
        public Graf()
        {
            cvorovi = null; brojCvorova = 0;
        }
        public Cvor pronadjiCvor(int pod)
        {
            Cvor cvor = cvorovi;
            while (cvor != null && !cvor.podatak.Equals(pod))
                cvor = cvor.sledeci;
            return cvor;
        }
        public Grana pronadjiGranu(int a, int b)
        {
            Cvor polazni = pronadjiCvor(a);
            if (polazni == null)
                return null;
            Grana grana = polazni.grane;
            while (grana != null && grana.odrediste.podatak.Equals(b))
                grana = grana.sledeca;
            return grana;
        }
        public void prikazi()
        {
            Cvor cvor = cvorovi;
            while (cvor != null)
            {
                Console.Write(cvor.podatak.ToString() + " -> ");
                Grana grana = cvor.grane;
                while (grana != null)
                {
                    Console.Write(grana.odrediste.podatak.ToString() + " - " + grana.tezina.ToString() + " | ");
                    grana = grana.sledeca;
                }
                Console.WriteLine();
                cvor = cvor.sledeci;
            }
        }
        public bool dodajCvor(int pod)
        {
            Cvor noviCvor = new Cvor(pod, null, cvorovi, 0);
            cvorovi = noviCvor;
            brojCvorova++;
            return true;
        }
        public bool dodajGranu(int a, int b, double tezina)
        {
            Cvor polazni = pronadjiCvor(a);
            Cvor dolazni = pronadjiCvor(b);
            if (polazni == null || dolazni == null)
                return false;
            Grana novaGana = new Grana(dolazni, polazni.grane, tezina);
            polazni.grane = novaGana;
            return true;
        }
        public void prikaziCvorove(bool bStatus = false)
        {
            for (Cvor cvor = cvorovi; cvor != null; cvor = cvor.sledeci)
            {
                cvor.prikazi(bStatus);
            }
        }
        public int vratiPut(int pocetniint, int krajnjiint)
        {
            Cvor pocetni = pronadjiCvor(pocetniint);
            Cvor krajnji = pronadjiCvor(krajnjiint);
            return vratiPut(krajnji);
        }
        public int vratiPut(Cvor cvor)
        {
            int br = 0;
            if (cvor != null)
            {
                br++;
                br += vratiPut(cvor.prethodni);
            }
            return br;
        }
    };
        partial class Graf
    {
        private void dodajURedSaPrioritetom(LinkedList<Cvor> redSaPrioritetom, Cvor cvor)
        {
            LinkedListNode<Cvor> llcvor = redSaPrioritetom.First;
            while (llcvor != null && llcvor.Value.duzinaPuta < cvor.duzinaPuta)
            {
                llcvor = llcvor.Next;
            }
            if (llcvor != null)
            {
                redSaPrioritetom.AddBefore(llcvor, cvor);
            }
            else
            {
                redSaPrioritetom.AddLast(cvor);
            }
        }
        private void azurirajRedSaPrioritetom(LinkedList<Cvor> redSaPrioritetom, Cvor cvor)
        {
            LinkedListNode<Cvor> llcvor = redSaPrioritetom.First;
            while (llcvor != null && !llcvor.Value.podatak.Equals(cvor.podatak))
            {
                llcvor = llcvor.Next;
            }
            redSaPrioritetom.Remove(llcvor.Value);
            dodajURedSaPrioritetom(redSaPrioritetom, cvor);
        }

        public long najkraciPut(int pocetniint)
        {
            long brojObradjenihCvorova = 0;
            Cvor cvor = cvorovi;
            LinkedList<Cvor> redSaPrioritetom = new LinkedList<Cvor>();
            while (cvor != null)
            {
                cvor.status = 1;
                cvor.duzinaPuta = Double.MaxValue;
                cvor = cvor.sledeci;
            }
            cvor = pronadjiCvor(pocetniint);
            if (cvor == null)
                return 0;
            redSaPrioritetom.AddLast(cvor);
            cvor.status = 2;
            cvor.duzinaPuta = 0;
            while (redSaPrioritetom.Count > 0)
            {
                cvor = redSaPrioritetom.First();
                redSaPrioritetom.RemoveFirst();
                cvor.status = 3;
                brojObradjenihCvorova += 1;
                Grana grana = cvor.grane;
                while (grana != null)
                {
                    if (grana.odrediste.status == 1)
                    {
                        grana.odrediste.duzinaPuta = cvor.duzinaPuta + grana.tezina;
                        grana.odrediste.status = 2;
                        grana.odrediste.prethodni = cvor;
                        dodajURedSaPrioritetom(redSaPrioritetom, grana.odrediste);
                    }
                    else if (grana.odrediste.status == 2)
                    {
                        if (grana.odrediste.duzinaPuta > cvor.duzinaPuta + grana.tezina)
                        {
                            grana.odrediste.duzinaPuta = cvor.duzinaPuta + grana.tezina;
                            grana.odrediste.prethodni = cvor;
                            azurirajRedSaPrioritetom(redSaPrioritetom, grana.odrediste);
                        }
                    }
                    grana = grana.sledeca;
                }
            }
            return brojObradjenihCvorova;
        }
    }
    class Program
    {
        static void NapraviGraf(Graf graf, int[] cvorovi, int[] grane)
        {
            for (int i = 0; i < cvorovi.Length; i++)
            {
                graf.dodajCvor(cvorovi[i]);
            }
            for (int i = 0; i < grane.Length / 3; i++)
            {
                graf.dodajGranu(grane[3 * i], grane[3 * i + 1], grane[3 * i + 2]);
            }
        }
        static void NapraviGraf(Graf graf, int[] cvorovi, int[,] grane)
        {
            for (int i = 0; i < cvorovi.Length; i++)
            {
                graf.dodajCvor(cvorovi[i]);
            }
            for (int i = 0; i < grane.Length / 3; i++)
            {
                graf.dodajGranu(grane[i, 0], grane[i, 1], grane[i, 2]);
            }
        }
        static int partition(Teritorije[] niz, int k, int l)
        {
            int pivot = niz[l].brojVeza;
            int j = k - 1;
            for (int i = k; i < l; i++)
            {
                if (niz[i].brojVeza > pivot)
                {
                    j++;
                    Teritorije p = niz[j];
                    niz[j] = niz[i];
                    niz[i] = p;
                }
            }
            Teritorije q = niz[j + 1];
            niz[j + 1] = niz[l];
            niz[l] = q;
            return j + 1;
        }
        static void quicksort(Teritorije[] niz, int k, int l)
        {
            if (k < l)
            {
                int pi = partition(niz, k, l);
                quicksort(niz, k, pi - 1);
                quicksort(niz, pi + 1, l);
            }
        }
        public struct Teritorije
        {
            public int brojTeritorije;
            public int brojVeza;
        }
        static void Main(string[] args)
        {
            int N = Convert.ToInt32(Console.ReadLine());
            int[] u = new int[N];
            int[] v = new int[N];
            Graf graf = new Graf();
            int[] cvorovi = new int[N];
            Teritorije[] pom = new Teritorije[N];
            for(int i = 0; i < N - 1; i++)
            {
                string s = Console.ReadLine();
                string[] s1 = s.Split(' ');
                u[i] = Convert.ToInt32(s1[0]);
                v[i] = Convert.ToInt32(s1[1]);
                pom[u[i] - 1].brojVeza++;
                pom[v[i] - 1].brojVeza++;
            }
            int[,] grane = new int[N, 3];
            for(int i = 0; i < N; i++)
            {
                pom[i].brojTeritorije = i + 1;
                cvorovi[i] = i + 1;
                grane[i, 0] = u[i];
                grane[i, 1] = v[i];
                grane[i, 2] = 0;
            }
            quicksort(pom, 0, N - 1);
            NapraviGraf(graf, cvorovi, grane);
            int max = 0;
            if (N % 2 == 0)
            {
                for (int i = 0; i < N / 2; i++)
                {
                    for(int j = 1; j < N / 2; j++)
                    {
                        graf.najkraciPut(pom[i].brojTeritorije);
                        if(max<graf.vratiPut(pom[i].brojTeritorije, pom[j].brojTeritorije))
                        {
                            max = graf.vratiPut(pom[i].brojTeritorije, pom[j].brojTeritorije);
                        }
                    }
                }
            }
            else
            {
                for (int i = 0; i < N / 2; i++)
                {
                    for (int j = 1; j < N / 2 + 1; j++)
                    {
                        graf.najkraciPut(pom[i].brojTeritorije);
                        if (max < graf.vratiPut(pom[i].brojTeritorije, pom[j].brojTeritorije))
                        {
                            max = graf.vratiPut(pom[i].brojTeritorije, pom[j].brojTeritorije);
                        }
                    }
                }
            }
            Console.WriteLine(max);
            Console.ReadLine();
        }
    }
}