#include <iostream>
#include <vector>
#include <algorithm>
#include <queue>
using namespace std;

int diameter[100001]; 

int bfs( int init, vector<int> arr[], int n ) 
{  
    queue<int> q; 
    q.push(init); 
  
    int visited[100001]; 
    for ( int i = 0; i <= n; i++ ) 
	{ 
        visited[i] = 0; 
        diameter[i] = 0; 
    } 
  
    
     q.push(init); 
    
    visited[init] = 1; 
    while (!q.empty()) { 
        int u = q.front(); 
        q.pop(); 
        for (int i = 0; i < arr[u].size(); i++) { 
            if (visited[arr[u][i]] == 0) { 
                visited[arr[u][i]] = 1; 
  
        
                diameter[arr[u][i]] += diameter[u] + 1; 
                q.push(arr[u][i]); 
            } 
        } 
    } 
  
    return int(max_element(diameter + 1, diameter + n + 1) -diameter); 
} 
  
int findDiameter(vector<int> arr[], int n) 
{ 
    int init = bfs(1, arr, n); 
    int val = bfs(init, arr, n); 
    return diameter[val]; 
} 

int main()
{
	int n;
	int u,v;
	 
	cin >> n;
	vector<int> arr[10001];
    for ( int g = 0; g < n-1; g++ )
	{
		cin >> u >> v;
		arr[u].push_back(v);
		arr[v].push_back(u);
	}

	int d = findDiameter( arr, n );
	sort( diameter+1, diameter+n+1 );
	int j = n, r = 1, k = 0;
	int rastojanje = 0;
	bool radi = 1;
	
	while ( radi )
	{
		while ( diameter[j] == diameter[j-1]+rastojanje )
		{
			j--;
			k++;
			if ( k == n/2 )
			{
				radi = false; 
				break;
			}
		}
		if ( !radi ) continue;

		while ( diameter[r] == diameter[r+1]+rastojanje )
		{
			r++;
			k++;
			if ( k == n/2 )
			{
				radi = false;
				break;
			}
		} 
		if ( !radi ) continue;	
		rastojanje++;
	}

	cout << diameter[j]-diameter[r] << endl;

	return 0;
}