#include <bits/stdc++.h>

#define pb push_back
#define MAXN 100010

using namespace std;

enum igrac { prvi, drugi };

vector<int> graph[MAXN];
bool nextToFirst[MAXN];

bool cmp(int a, int b) {

    if(nextToFirst[a] && !nextToFirst[b])
        return true;
    return graph[a].size() > graph[b].size();
}

int bfs(int src, int dist[]) {

    dist[src] = 0;
    queue<int> q;
    q.push(src);
    int mxd = INT_MIN;
    while(!q.empty()) {
        int u = q.front();
        q.pop();

        for(int v: graph[u]) {
            if(dist[v] == -1) {
                dist[v] = dist[u] + 1;
                mxd = max(mxd, dist[v]);
                q.push(v);
            }
        }
    }
    return mxd;
}

int solve(int src, int n) {

    int dist[n];
    for(int i = 0; i < n; i++)
        dist[i] = -1, nextToFirst[i] = false;
    int mxd = bfs(src, dist);

    vector<int> d[mxd + 1];
    for(int i = 0; i < n; i++)
        d[dist[i]].pb(i);
    
    igrac who[n];
    who[src] = prvi;
    for(int k: graph[src])
        nextToFirst[k] = true;
    igrac ig = drugi;
    for(int i = 1; i <= mxd; i++) {
        unordered_map<int, bool> used;
        sort(d[i].begin(), d[i].end(), cmp);
        for(int k: d[i]) {
            who[k] = ig;
            if(ig == prvi) {
                ig = drugi;
                for(int v: graph[k])
                    nextToFirst[v] = true;
            } else {
                ig = prvi;
            }
        }
    }

    int ans = INT_MIN;
    for(int i = 0; i < n; i++) {
        if(who[i] != prvi)
            continue;
        for(int j = 0; j < n; j++)
            dist[j] = -1;
        bfs(i, dist);
        for(int j = 0; j < n; j++)
            if(who[j] == prvi)
                ans = max(ans, dist[j]);
    }

    return ans;
}

int main() {

    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);

    int n;
    cin >> n;
    bool z = true;
    for(int i = 0; i < n - 1; i++) {
        int u, v;
        cin >> u >> v;
        u--;
        v--;
        if(u != v + 1 && v != u + 1)
            z = false;

        graph[u].pb(v);
        graph[v].pb(u);
    }
  
    if(z) {
        if(n & 1)
            cout << n - 2 << endl;
        else
            cout << n - 3 << endl;
        return 0;
    }

    int ans = n;
    for(int i = 0; i < n; i++)
        ans = min(ans, solve(i, n));
    cout << ans << endl;
    return 0;
}