#include <iostream>
#include <map>
#include <vector>

int main()
{
    unsigned long long N, K;
    std::cin >> N >> K;

    std::map<long long, unsigned long long> hits;
    for (unsigned long long i = 1; i <= N; i++)
    {
        long long hit;
        std::cin >> hit;

        if (hits.find(hit) == hits.end())
        {
            hits[hit] = 1;
        }
        else
        {
            hits[hit]++;
        }
    }

    std::vector<long long> to_print;
    to_print.reserve(hits.size());
    for (std::pair<long long, unsigned long long> pair : hits)
    {
        if (pair.second >= K)
        {
            to_print.emplace_back(pair.first);
        }
    }

    std::cout << to_print.size() << std::endl;
    for (long long p : to_print)
    {
        std::cout << p << " ";
    }

    return 0;
}