#include<stdio.h>
#include<vector>

void input(std::vector<int>&, int&, unsigned int&);
std::vector<int> calc(std::vector<int>, int, unsigned int);
void output(std::vector<int>);

int main(){
    std::vector<int> in;
    int n;
    unsigned int k;

    input(in, n, k);
    auto res = calc(in, n, k);
    output(res);

    return 0;
}

void input(std::vector<int>& t_in, int& t_n, unsigned int& t_k){
    scanf("%d%d", &t_n, &t_k);
    t_in.resize(t_n);
    for(int i = 0; i < t_n; ++i) scanf("%d", &t_in[i]);
}

std::vector<int> calc(std::vector<int> t_in, int t_n, unsigned int t_k){
    std::vector<int> res;
    std::vector<unsigned int> count(2*t_n + 1);

    for(auto& t : t_in){
        if(++count[t + t_n] == t_k){
            res.push_back(t);
        }
    }

    return res;
}

void output(std::vector<int> t_res){
    printf("%zu\n", t_res.size());
    for(auto& r : t_res) printf("%d ", r);
    printf("\n");
}