#include<stdio.h>
#include<vector>
#include<algorithm>

#include<iostream>

void input(std::vector<int>&);
void calc(std::vector<int>&);
void output(std::vector<int>);

std::pair<int, int> update_max(int, std::pair<int, int>, int);

int main(){
    std::vector<int> in;

    input(in);
    calc(in);
    output(in);

    return 0;
}

void input(std::vector<int>& t_in){
    int size;
    std::cin >> size;
    t_in.resize(size);
    for(auto& t : t_in) std::cin >> t;
}

std::pair<int, int> update_max(int t_cur, std::pair<int, int> t_prev, int i){
    return t_cur > t_prev.first ? std::make_pair(t_cur, i) : t_prev;
}

void calc(std::vector<int>& t_in){
    std::vector< std::pair<int, int> > max_pos(t_in.size());

    max_pos.back() = std::make_pair(t_in.back(), t_in.size() - 1);

    for(int i = t_in.size() - 2; i >= 0; --i){
        max_pos[i] = update_max(t_in[i], max_pos[i+1], i);
    }

    for(int i = 0; i < t_in.size(); ++i){
        if(max_pos[i].second != i){
            std::swap(t_in[i], t_in[max_pos[i].second]);
            return;
        }
    }

    std::swap(t_in[t_in.size() - 1],
              t_in[t_in.size() - 2]);
}

void output(std::vector<int> t_in){
    for(auto& t : t_in) std::cout << t << " ";
    std::cout << "\n";
}