#include <algorithm>
#include <iostream>
#include <iomanip>
#include <vector>
#include <cmath>

#define ld long double

using namespace std;

int W, H, R;

template <class T>
void printVector(vector<T> v) {
	cout << "->";
	for (auto x : v) {
		cout << x << " ";
	}
	cout << endl;
}

ld chop(int x0, int x, int y) {
	ld d = y - sqrtl(powl(R, 2) - powl(x0 - x, 2));
	return d > 0 ? d : 0;
}

template <class T>
void bite(vector<T> &v, int x, int y) {
	int n = v.size();
	for (int i = max(0,x-R); i < min(x+R,n) ; i++) {
		v[i] = fminl(v[i], chop(i, x, y));
	}
}

template <class T>
void measure(vector<T> &v, int x) {
	cout << v[x] << endl;
}

template <class T>
void operate(vector<T> &v) {
	int op;
	cin >> op;
	if (op == 1) {
		int x, y;
		cin >> x >> y;
		bite(v, x, y);
	}
	else if (op == 2) {
		int x;
		cin >> x;
		measure(v, x);
	};
}

int main()
{	
	cout << fixed << setprecision(9);

	int Q;
	cin >> W >> H >> R >> Q;

	vector<ld> xOy(W + 1, H);

	for (int i = 0; i < Q; i++) {
		operate(xOy);
	}
}