#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define FREE 1
#define LOCKED 2
#define DLOCKED 3

typedef struct {
    int x;
    int y;
    int mode;
} goldCoin;

int findNearestCoinX (int N, int line, goldCoin* coins, int lockStatus, int inc) {
    for (int i = 0; i < N; ++i) {
            if (coins[i].x == line && coins[i].mode != lockStatus) {
                return i;
            }else if (i == (N-1)){
                if (inc > 0 && line + (inc* -1 - 1) >= 0)
                    inc = inc* -1 - 1;
                else
                    inc = inc * -1 + 1;
                return (findNearestCoinX(N, line+inc, coins, lockStatus, inc));
            }
    }
    return -1;
}

int findNearestCoinY (int N, int line, goldCoin* coins, int lockStatus, int inc) {
    for (int i = 0; i < N; ++i) {
            if (coins[i].y == line && coins[i].mode != lockStatus) {
                return i;
            }else if (i == (N-1)){
                if (inc > 0)
                    inc = inc* -1 - 1;
                else
                    inc = inc * -1 +1;
                return (findNearestCoinY(N, line+inc, coins, lockStatus, inc));
            }
    }
    return -1;
}

int main()
{
    int N;
    int totalTime = 0;
    scanf("%d", &N);
    goldCoin* coins =(goldCoin*) calloc(N, sizeof(goldCoin));
    for (int i = 0; i < N; ++i) {
        scanf("%d %d", &coins[i].x, &coins[i].y);
        coins[i].x--;
        coins[i].y--;
        coins[i].mode = FREE;
    }


/*
    for(int i=0;i<N;i++)
        {
            for(int j=i;j<N;j++)
            {
                if(coins[i].x>coins[j].x)
                {
                    goldCoin a = coins[i];
                    coins[i] = coins[j];
                    coins[j] = a;
                }
            }
        }

    for(int i=0;i<N;i++)
        {
            for(int j=i;j<N;j++)
            {
                if(coins[i].y>coins[j].y)
                {
                    goldCoin a = coins[i];
                    coins[i] = coins[j];
                    coins[j] = a;
                }
            }
        }
*/


    for (int kolona = 0; kolona < N; ++kolona) {
        int coinIndex = findNearestCoinY(N, kolona, coins, LOCKED, 1);
        totalTime += abs(kolona - coins[coinIndex].y);
        coins[coinIndex].y = kolona;
        coins[coinIndex].mode = LOCKED;
    }


    for (int red = 0; red < N; ++red) {
        int coinIndex = findNearestCoinX(N, red, coins, DLOCKED, 1);
        totalTime += abs(red - coins[coinIndex].x);
        coins[coinIndex].x = red;
        coins[coinIndex].mode = DLOCKED;
    }


    printf("%d", totalTime);

    return 0;
}