public class Pikado {

 
    private int n;
    private int k;
    private List<Integer> pogodjenaPolja;

    public static void main(String[] args) {
        Pikado pikado = new Pikado();
        try {
            pikado.ucitaj();
            pikado.poljaZaZamenu();
        } catch (IOException ex) {
            Logger.getLogger(Pikado.class.getName()).log(Level.SEVERE, null, ex);
        }

    }

    public void ucitaj() throws IOException {
        System.out.println("Unesite broj strelica(N) i broj nakon kog treba zameniti polje(K) u formatu: N K");
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        String ulaz = in.readLine();
        String[] brojevi = ulaz.split(" ");
        n = Integer.parseInt(brojevi[0]);
        k = Integer.parseInt(brojevi[1]);
        if (n > 1000000 || k > 1000000) {
            System.out.println("Uneti brojevi su preveliki");
            return;
        }

        System.out.println("Unesite pogodjna polja redom sa razmacima izmedju svaka dva broja:");
        ulaz = in.readLine();
        String[] polja = ulaz.split(" ");

        if (polja.length > n) {
            System.out.println("Neispravno unet broj strelica");
            return;
        }
        pogodjenaPolja = new ArrayList<>();

        for (int i = 0; i < polja.length; i++) {
            Integer polje = Integer.parseInt(polja[i]);
            if (polje < (-1 * n) || polje > n) {
                System.out.println("Neispravno unete strelice!");
                return;
            } else {
                pogodjenaPolja.add(Integer.parseInt(polja[i]));
            }
        }
    }

    public void poljaZaZamenu() {
        List<Integer> poljaPogodjenaKPuta = new ArrayList<>();
        int brojac = 0;

        for (int i = 0; i < pogodjenaPolja.size(); i++) {
            if (!daLiListaSadrziPolje(pogodjenaPolja.get(i), poljaPogodjenaKPuta)) {
                if (daLiJePogodjenoKPuta(pogodjenaPolja.get(i))) {
                    brojac++;
                    poljaPogodjenaKPuta.add(pogodjenaPolja.get(i));
                }
            }

        }
        System.out.println(brojac);
        for (int i = 0; i < poljaPogodjenaKPuta.size(); i++) {
            System.out.print(poljaPogodjenaKPuta.get(i) + " ");
        }

    }

    private boolean daLiJePogodjenoKPuta(Integer polje) {
        int brojac = 0;
        for (int i = 0; i < pogodjenaPolja.size(); i++) {
            if (pogodjenaPolja.get(i).compareTo(polje) == 0) {
                brojac++;
                if (brojac == k) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean daLiListaSadrziPolje(Integer polje, List<Integer> poljaPogodjenaKPuta) {
        for (int i = 0; i < poljaPogodjenaKPuta.size(); i++) {
            if (poljaPogodjenaKPuta.get(i).compareTo(polje) == 0) {
                return true;
            }
        }
        return false;
    }
}