import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class Main {

    public static void main(String args[]) {
        Scanner scanner = new Scanner(System.in);
        String[] whrq = scanner.nextLine().split(" ");

        int w = Integer.parseInt(whrq[0]);
        int h = Integer.parseInt(whrq[1]);
        int r = Integer.parseInt(whrq[2]);

        int q = Integer.parseInt(whrq[3]);

        List<Krug> krugovi = new ArrayList<>();

        Akcija[] akcije = new Akcija[q];
        for (int i = 0; i < q; i++) {
            String argumenti = scanner.nextLine();
            if(argumenti.startsWith("1")) {
                akcije[i] = new Krug(argumenti);
            } else {
                akcije[i] = new Pogled(argumenti);
            }
        }

        scanner.close();

        for (Akcija akcija : akcije) {
            if(akcija.type == 1) {
                krugovi.add((Krug) akcija);
            } else {
                System.out.println(((Pogled) akcija).izracunaj(w, h, r, krugovi));
            }

        }

    }

    public static abstract class Akcija {
        public int type;
        public Akcija(int type) {
            this.type = type;
        }
    }
    public static class Krug extends Akcija {
        public int x;
        public int y;
        public Krug(String s) {
            super(1);
            String[] args =s.split(" ");
            this.x = Integer.parseInt(args[1]);
            this.y = Integer.parseInt(args[2]);
        }
    }
    public static class Pogled extends Akcija {
        public int x;

        public Pogled(String s) {
            super(2);
            String[] args =s.split(" ");
            this.x = Integer.parseInt(args[1]);
        }

        public double izracunaj(int w, int h, int r, List<Krug> krugovi) {
            double rezultat = h;
            for (Krug krug : krugovi) {
                double deltaykvadrat =  r*r - (krug.x - x)*(krug.x - x);
                if(deltaykvadrat < -1) {continue;}
                double udaljenost = krug.y - Math.sqrt(deltaykvadrat);
                if(rezultat > udaljenost) rezultat = udaljenost;
            }

            return rezultat;
        }
    }

}