#include <bits/stdc++.h>
using namespace std;
int n;
vector <vector <int> > Graph;
vector <int> Deg;
vector <bool> Bio;

vector <vector <int> > Dist;
void ToAll(int source,int dest,int d=0){
    if(Bio[dest])return;
    Bio[dest]=1;
    Dist[source][dest]=d;
    Dist[dest][source]=d;
    for(int i=0;i<Graph[dest].size();i++){
        ToAll(source,Graph[dest][i],d+1);
    }
}
void InitDist(){
    for(int i=0;i<n;i++){
        Bio=vector <bool>(n,0);
        ToAll(i,i);
    }
}

bool OK(int k){
    vector <vector <int> > Gp(n);
    vector <int> Deg2(n);

    for(int i=0;i<n;i++){
        for(int j=i+1;j<n;j++){
            if(Dist[i][j]>k){
                Deg2[i]++;
                Deg2[j]++;
                Gp[i].push_back(j);
                Gp[j].push_back(i);
            }
        }
    }
    for(int i=0;i<n;i++){
        Bio[i]=0;
    }
    priority_queue<pair<int,int> > Ds;
    for(int i=0;i<n;i++){
        Ds.push(make_pair(Deg2[i],i));
    }
    int Selected=0;
    while(!Ds.empty()){
        pair <int,int> t=Ds.top();
        Ds.pop();
        if(Bio[t.second])continue;
        Selected++;
        Bio[t.second]=true;
        for(int i=0;i<Gp[t.second].size();i++){
                Bio[Gp[t.second][i]]=true;
            for(auto nod:Gp[Gp[t.second][i]]){
                if(!Bio[nod]){Deg2[nod]--;Ds.push(make_pair(Deg2[nod],nod));}

            }
        }
    }
    if(Selected>=n-1){
       // cout <<"OK: "<<k<<endl;
        return 1;
    }
    else{
        //cout <<"NOT OK: "<<k<<endl;
        return 0;
    }

}
int main(){
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
    int degMax=0;

    cin >>n;
    Graph.resize(n);
    Deg.resize(n);

    for(int i=0;i<n-1;i++){
        int x,y;
        cin >>x>>y;
        x--;
        y--;
        Graph[x].push_back(y);
        Graph[y].push_back(x);
        Deg[x]++;
        Deg[y]++;
        degMax=max(degMax,max(Deg[x],Deg[y]));
    }
    if(degMax==2){
        cout <<n-2-!(n%2)<<endl;
        return 0;
    }
    Dist.resize(n,vector <int> (n,-10));
    InitDist();


    int lo=1,hi=n;
    while(lo<hi){
        int mid=(lo+hi)/2;
        if(OK(mid))hi=mid-1;
        else lo=mid+1;
    }
    while(OK(lo))lo--;
    while(!OK(lo))lo++;
    cout <<lo<<endl;


}