#include <bits/stdc++.h>
using namespace std;

class Graph
{
    int V;
    list<int> *adj;

public:
    Graph(int V);
    void addEdge(int v, int w);
    int longestPathLength();
    pair<int, int> bfs(int u);

};

Graph::Graph(int V)
{
    this->V = V;
    adj = new list<int>[V];
}

void Graph::addEdge(int v, int w)
{
    adj[v].push_back(w);
    adj[w].push_back(v);
}

pair<int, int> Graph::bfs(int u)
{
    vector<int> dis(V, -1);
    queue<int> q;
    q.push(u);

    dis[u] = 0;

    while (!q.empty())
    {
        int t = q.front();
        q.pop();

        for (auto it = adj[t].begin(); it != adj[t].end(); it++)
        {
            int v = *it;

            if (dis[v] == -1)
            {
                q.push(v);
                dis[v] = dis[t] + 1;
            }
        }
    }

    int maxDis = 0;
    int nodeIdx;

    for (int i = 0; i < V; i++)
    {
        if (dis[i] > maxDis)
        {
            maxDis = dis[i];
            nodeIdx = i;
        }
    }
    return make_pair(nodeIdx, maxDis);
}

int Graph::longestPathLength()
{
    pair<int, int> t1, t2;

    t1 = bfs(0);
    t2 = bfs(t1.first);

    return t2.second;
}

int main()
{
    ios::sync_with_stdio(false);
    cin.tie(0);
    int n, u, v;
    cin>>n;
    Graph g(n);
    for(int i=0; i<n-1; i++){
        cin>>u>>v;
        g.addEdge(u-1, v-1);
    }

    int d = g.longestPathLength();
    if(d== n-1){
        if(n%2==0)
            cout<<n-3;
        else cout<<n-2;
    }
    else{
        cout<<d<<endl;
    }
    return 0;
}