#include <iostream>
#include <cstdlib>

void floodFill(int *arr, int width, int height, int x, int y, int color) {
	if (arr[y * width + x] != 0) return;

	int x1;

	x1 = x;
	while (x1 < width && arr[y * width + x1] == 0) {
		arr[y * width + x1] = color;
		++x1;
	}

	x1 = x - 1;
	while (x1 >= 0 && arr[y * width + x1] == 0) {
		arr[y * width + x1] = color;
		--x1;
	}

	if (y > 0) {
		x1 = x;
		while (x1 < width && arr[y * width + x1] == color) {
			if (arr[(y - 1) * width + x1] == 0)
				floodFill(arr, width, height, x1, y - 1, color);
			++x1;
		}

		x1 = x - 1;
		while (x1 >= 0 && arr[y * width + x1] == color) {
			if (arr[(y - 1) * width + x1] == 0)
				floodFill(arr, width, height, x1, y - 1, color);
			--x1;
		}
	}

	if (y < height - 1) {
		x1 = x;
		while (x1 < width && arr[y * width + x1] == color) {
			if (arr[(y + 1) * width + x1] == 0)
				floodFill(arr, width, height, x1, y + 1, color);
			++x1;
		}

		x1 = x - 1;
		while (x1 >= 0 && arr[y * width + x1] == color) {
			if (arr[(y + 1) * width + x1] == 0)
				floodFill(arr, width, height, x1, y + 1, color);
			--x1;
		}
	}
}

int main() {
	std::ios_base::sync_with_stdio(false);
	
	int width, height, n;
	std::cin >> width >> height >> n;

	int *arr = (int*)calloc(width * height, sizeof(int));

	for (int i = 0; i < n; ++i) {
		int x, y;
		std::cin >> x >> y;
		arr[(y - 1) * width + x - 1] = 1;
	}

	int color = 1;
	for (int y = 0; y < height; y++)
		for (int x = 0; x < width; x++)
			if (arr[y * width + x] == 0)
				floodFill(arr, width, height, x, y, ++color);

	std::cout << --color; //because color starts at 1
	/*print the array
	std::cout << std::endl;
	for (int y = 0; y < height; y++) {
		for (int x = 0; x < width; x++)
			std::cout << arr[y * width + x] << " ";
		std::cout << "\n\n";
	}
	//*/
	delete[] arr;
	//system("pause"); 
	return 0;
}