#include <iostream>
#include <algorithm>
#include <math.h>

using namespace std;

typedef long long ll;
typedef unsigned long long ull;

void print_vertex(ull x, ull y) {
    cout << x << " " << y << "\n";
}

int main() {
    ull n;
    cin >> n;

    // no 3 points on a circle are collinear
    // 2 points + center = collinear
    // generate always a regular polygon

    const ull points = (2 * n) + 1;
    const ull radius = 10e9;
    cout << points << endl;

    print_vertex(0, 0); // Centre

    for (int i = 1; i <= points - 1; i++) {
        cout << i << " ";
        double ang = 2 * 3.14159265359 / points - 1 * i;
        double c = cos(ang);
        double s = sin(ang);

        cout << c << " " << s << endl;
        ull x = (ull)(radius * c);
        ull y = (ull)(radius * s);

        print_vertex(x, y);
    }
    return 0;
}