#include <iostream>
#include <chrono>
#include <thread>
#include <math.h>

using namespace std;

void swap(int* a, int* b)
{
	int t = *a;
	*a = *b;
	*b = t;
}

int partition(int arr[], int low, int high)
{
	int pivot = arr[high];
	int i = (low - 1);

	for (int j = low; j <= high - 1; j++)
	{
		if (arr[j] < pivot)
		{
			i++;
			swap(&arr[i], &arr[j]);
		}
	}
	swap(&arr[i + 1], &arr[high]);
	return (i + 1);
}

void quickSort(int arr[], int low, int high)
{
	if (low < high)
	{
		int pi = partition(arr, low, high);

		quickSort(arr, low, pi - 1);
		quickSort(arr, pi + 1, high);
	}
}

int main()
{
	const int N = 1000000;
	unsigned int n = 0;
	int x = 0, min = 0, max = 0, sum = 0;
	int kuce[N];

	cin >> n >> x;

	for (int i = 0; i < n; i++)
	{
		scanf_s("%i", &kuce[i]);
	}

	quickSort(kuce, 0, n - 1);

	min = kuce[0];
	max = kuce[n-1];
	int abMin = abs(x - min);
	int abMax = abs(x - max);

	if (abMin > abMax)
	{
		sum = abMax + abs(max - min);
	}
	else
	{
		sum = abMin + abs(max - min);
	}
	cout << sum;
}