#include <bits/stdc++.h>

using namespace std;

bool IsInRange(int r, int c, int N, int M)
{
    return r > -1 && r < N && c > -1 && c < M;
}

void FillColor(bool **Table, int r, int c, int N, int M)
{
    Table[r][c] = true;
    if(IsInRange(r+1, c, N, M) && !Table[r+1][c])
    {
        FillColor(Table, r+1, c, N, M);
    }

    if (IsInRange(r-1, c, N, M) && !Table[r-1][c])
    {
        FillColor(Table, r-1, c, N, M);
    }

    if (IsInRange(r, c+1, N, M) && !Table[r][c+1])
    {
        FillColor(Table, r, c+1, N, M);
    }

    if (IsInRange(r, c-1, N, M) && !Table[r][c-1])
    {
        FillColor(Table, r, c-1, N, M);
    }
}

int main()
{
    ios::sync_with_stdio(false);
    cin.tie(NULL);

    int N, M, K, t, s, Colors = 0;
    cin >> N >> M >> K;

    bool **Table = new bool*[N];
    for(int i = 0; i < N; ++i)
    {
        Table[i] = new bool[M];
    }

    for(int i = 0; i < N; ++i)
    {
        for(int j = 0; j < M; ++j)
        {
            Table[i][j] = false;
        }
    }

    for(int i = 0; i < K; ++i)
    {
        cin >> t >> s;
        Table[t-1][s-1] = true;
    }

    for(int i = 0; i < N; ++i)
    {
        for(int j = 0; j < M; ++j)
        {
            if(!Table[i][j])
            {
                FillColor(Table, i, j, N, M);
                ++Colors;
            }
        }
    }

    cout << Colors;

    return 0;
}