//https://www.geeksforgeeks.org/flood-fill-algorithm-implement-fill-paint/
#include<bits/stdc++.h> 
using namespace std; 

vector<vector<int> > screen;

void floodFillUtil(int M, int N, int x, int y, int prevC, int newC) 
{ 
    if (x < 0 || x >= M || y < 0 || y >= N) 
        return; 
    if (screen[x][y] != prevC) 
        return; 

    screen[x][y] = newC; 

    floodFillUtil(M, N, x+1, y, prevC, newC); 
    floodFillUtil(M, N, x-1, y, prevC, newC); 
    floodFillUtil(M, N, x, y+1, prevC, newC); 
    floodFillUtil(M, N, x, y-1, prevC, newC); 
} 
  
void floodFill(int M, int N, int x, int y, int newC) 
{ 
    int prevC = screen[x][y]; 
    floodFillUtil(M, N, x, y, prevC, newC); 
} 
  
int main() 
{ 
    int m, n, k, res = 2, x, y;
    cin >> m >> n >> k;

    screen.resize(m, vector<int>(n));

    for (auto &i : screen)
    std::fill(i.begin(), i.end(), 0);

    for (int i = 0; i < k; ++i) {
        cin >> x >> y;
        screen[x-1][y-1] = 1;
    }
  
    for (int i = 0; i < m; ++i) {
        for (int j = 0; j < n; ++j) {
            if (screen[i][j] == 0) {
                floodFill(m, n, i, j, res);
                ++res;
            }
        }
    }

    res -= 2;
    cout << res;
}