#include <iostream>
#include <cstring>
#include <stack>
using namespace std;

#define loop(i,a,b) for(ll i = a; i < b; ++i)

typedef long long ll;

ll rows, columns;
ll segment_count;
ll unsearched_count;

int neighbors[][2] = {{1,0},{-1,0},{0,1},{0,-1}};

//void print(int* board){
//    loop(row, 0, rows){
//    	loop(column, 0, columns){
//    		cout << *(board + row*rows + column) << " ";
//    	}
//    	cout << "\n";
//    }
//}

//iterativni DFS
stack<pair<ll, ll> > myStack;
void DFS(int* board, int row, int column){
	myStack.push(make_pair(row, column));
	while(!myStack.empty()){
		ll current_row = myStack.top().first;
		ll current_column = myStack.top().second;
		myStack.pop();
		board[current_row*rows + current_column] = true;
		--unsearched_count;
		loop(i, 0, 4){
			ll nrow = current_row+neighbors[i][1];
			ll ncol = current_column + neighbors[i][0];

			if(nrow < 0 || nrow > rows-1 || ncol < 0 || ncol > columns-1) continue;
			bool chnval = !(*(board + nrow*rows + ncol));

			if(chnval){
				myStack.push(make_pair(nrow, ncol));
			}
		}
	}
}

void fill(int* board){
    loop(row, 0, rows){
    	if(unsearched_count==0) break;
    	loop(column, 0, columns){
    		if(unsearched_count==0) break;
    		if(!(*(board + row*rows + column))){
    			++segment_count;
    			DFS((int*)board, row, column);
    		}
    	}
    }
}

int main(){
	ios::sync_with_stdio(0);
	cin.tie(0);

	cin >> rows >> columns;
	int board[rows][columns];
	memset(board, false, sizeof(board));

	ll pre_searched_count;
	cin >> pre_searched_count;
	loop(i, 0, pre_searched_count){
		ll row, column; 	cin >> row >> column;
		board[row-1][column-1] = true;
	}
	unsearched_count = rows*columns - pre_searched_count;
	segment_count = 0;

    fill((int*)board);

    cout << segment_count;

    return 0;
}