#include <bits/stdc++.h>
using namespace std;


vector<vector<int> > dirs = { { 0, -1 },
                              { -1, 0 },
                              { 0, 1 },
                              { 1, 0 } };


void dfs(vector<vector<int> >& grid, int x0, int y0,
         int i, int j, vector<pair<int, int> >& v)
{
    int rows = grid.size(), cols = grid[0].size();

    if (i < 0 || i >= rows || i < 0
        || j >= cols || grid[i][j] <= 0){
        return;
    }


    grid[i][j] *= -1;

    v.push_back({ i - x0, j - y0 });


    for (auto dir : dirs) {
        dfs(grid, x0, y0, i + dir[0], j + dir[1], v);
    }
}


int countDistinctIslands(vector<vector<int> >& grid)
{
    int rows = grid.size();
    if (rows == 0){
        return 0;
    }
    int cols = grid[0].size();
    if (cols == 0){
        return 0;
    }
    set<vector<pair<int, int> > > coordinates;
    coordinates.insert(vector<pair<int,int > >(0));
    for (int i = 0; i < rows; ++i) {
        for (int j = 0; j < cols; ++j) {


            if (grid[i][j] != 1){
                continue;
            }

            vector<pair<int, int> > v;
            dfs(grid, i, j, i, j, v);


            coordinates.insert(v);
        }
    }

    return coordinates.size()-1;
}

int main()
{
    int n,m,k;
    cin>>n>>m>>k;

    vector<vector<int> > grid(n,vector<int> (m,1));
    for(int i=0;i<k;i++){
        int x,y;
        cin>>x>>y;
        grid[x-1][y-1]=0;
    }

    cout <<  countDistinctIslands(grid) <<endl;

    return 0;
}