import java.util.Scanner;

public class BrojBoja {

	private static int h;
	private static int w;

	public static void main(String[] args) {
		Scanner ulaz = new Scanner(System.in);
		int m = ulaz.nextInt();
		int k = ulaz.nextInt();
		int n = ulaz.nextInt();
		
		char[][] matrica = new char[m][k];
		
		for (int i = 0; i < m; i++) {
			for (int j = 0; j < m; j++) {
				matrica[i][j] = '1';
			}
		}
		
		for (int i = 0; i < n; i++) {
			int x = ulaz.nextInt();
			int y = ulaz.nextInt();
			
			matrica[x-1][y-1] = '0';
		}
		
		System.out.println(new BrojBoja().brojBoja(matrica));
	}

	public int brojBoja(char[][] matrica) {
		h = matrica.length;
		if (h == 0)
			return 0;
		w = matrica[0].length;

		int islandCount = 0;
		
		boolean[][] postavljeni = new boolean[h][w];
		
		for (int i = 0; i < matrica.length; i++) {
			
			for (int j = 0; j < matrica[0].length; j++) {
				
				if (!postavljeni[i][j] && matrica[i][j] == '1') {
					brojKomsija(matrica, postavljeni, i, j);
					++islandCount;
				}
				
			}
			
		}
		return islandCount;
	}

	private void brojKomsija(char[][] matrica, boolean[][] postavljeni, int x, int y) {
		if (x < 0 || x >= h || y < 0 || y >= w || postavljeni[x][y] || matrica[x][y] != '1') {
			return;
		}
		
		postavljeni[x][y] = true;
		
		brojKomsija(matrica, postavljeni, x + 1, y);
		brojKomsija(matrica, postavljeni, x - 1, y);
		brojKomsija(matrica, postavljeni, x, y - 1);
		brojKomsija(matrica, postavljeni, x, y + 1);
	}

}