#include <bits/stdc++.h>
using namespace std;
class DisjointUnionSets
{

	vector<long long> rank, parent;
	long n;

	public:
	DisjointUnionSets(long n)
	{
		rank.resize(n);
		parent.resize(n);
		this->n = n;
		makeSet();
	}

	void makeSet()
	{
		for (long i = 0; i < n; i++)
			parent[i] = i;
	}
	long long find(long long x)
	{
		if (parent[x] != x)
		{
			return find(parent[x]);
		}

		return x;
	}
	void Union(long long x, long long y)
	{

		long long xRoot = find(x);
		long long yRoot = find(y);


		if (xRoot == yRoot)
			return;


		if (rank[xRoot] < rank[yRoot])
			parent[xRoot] = yRoot;


		else if (rank[yRoot] < rank[xRoot])
			parent[yRoot] = xRoot;

		else
		{

			parent[yRoot] = xRoot;


			rank[xRoot] = rank[xRoot] + 1;
		}
	}
};

long long countIslands(vector<vector<long long>>a)
{
	long long n = a.size();
	long long m = a[0].size();

	DisjointUnionSets *dus = new DisjointUnionSets(n * m);


	for (long long j = 0; j < n; j++)
	{
		for (long long k = 0; k < m; k++)
		{

			if (a[j][k] == 0)
				continue;



			if (j + 1 < n && a[j + 1][k] == 1)
				dus->Union(j * (m) + k,
						(j + 1) * (m) + k);
			if (j - 1 >= 0 && a[j - 1][k] == 1)
				dus->Union(j * (m) + k,
						(j - 1) * (m) + k);
			if (k + 1 < m && a[j][k + 1] == 1)
				dus->Union(j * (m) + k,
						(j) * (m) + k + 1);
			if (k - 1 >= 0 && a[j][k - 1] == 1)
				dus->Union(j * (m) + k,
						(j) * (m) + k - 1);
		}
	}
	long long *c = new long long[n * m];
	long long numberOfIslands = 0;
	for (long long j = 0; j < n; j++)
	{
		for (long long k = 0; k < m; k++)
		{
			if (a[j][k] == 1)
			{
				long long x = dus->find(j * m + k);
				if (c[x] == 0)
				{
					numberOfIslands++;
					c[x]++;
				}

				else
					c[x]++;
			}
		}
	}
	return numberOfIslands;
}
int main(void)
{

	/*vector<vector<long long>>a = {{1, 1, 0, 0, 0},
							{0, 1, 0, 0, 1},
							{1, 0, 0, 1, 1},
							{0, 0, 0, 0, 0},
							{1, 0, 1, 0, 1}};*/
    long long n,m,k,x,y;
    scanf("%lld%lld%lld",&n,&m,&k);
    vector<vector<long long>> matrica(n, vector<long long>(m,1));

	for(long long i=0;i<k;i++)
    {
        scanf("%lld%lld",&x,&y);
        matrica[x-1][y-1]=0;
    }
     /*for (int i = 0; i < matrica.size(); i++) {
        for (int j = 0; j < matrica[i].size(); j++)
            cout << matrica[i][j]<< " ";
        putchar('\n');
    }*/
		cout<< countIslands(matrica) << endl;
}