using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;

namespace test
{
    class Program
    {

        static void flood(int[,] grid, int x, int y, int color)
        {
            int n = grid.GetLength(0);
            int m = grid.GetLength(1);

            if (x < 0 || x >= n) return;
            if (y < 0 || y >= m) return;

            if (grid[x, y] == 0)
            {
                grid[x, y] = color;

                flood(grid, x + 1, y, color);
                flood(grid, x, y + 1, color);
                flood(grid, x - 1, y, color);
                flood(grid, x, y - 1, color);
            }
        }

        static void print<T>(T[,] matrica, int n, int m)
        {
            Console.WriteLine();
            for (int i = 0; i < n; i++)
            {
                for (int j = 0; j < m; j++)
                {
                    Console.Write("{0,2} ", matrica[i, j]);
                }
                Console.WriteLine();
            }
        }
        static void Main(string[] args)
        {
            

            string[] unos1 = Console.ReadLine().Split();

            long n = long.Parse(unos1[0]);
            long m = long.Parse(unos1[1]);
            int k = int.Parse(unos1[2]);

            int[,] grid = new int[n, m];

            for (int i = 0; i < k; i++)
            {
                string[] black= Console.ReadLine().Split();
                int y = int.Parse(black[0]) - 1;
                int x = int.Parse(black[1]) - 1;

                grid[y, x] = -2;
            }

            int color = 0;
            for (int i = 0; i < n; i++)
            {
                for(int j = 0; j < m; j++)
                {
                    if (grid[i, j] != 0)
                        continue;
                    
                    color++;
                    flood(grid, i, j, color);
                    
                }
            }

            Console.WriteLine(color);
        
        }
    }
}