#include <bits/stdc++.h>

#define MAXN_SMALL 1010

using namespace std;

bool visited[MAXN_SMALL][MAXN_SMALL];

void dfs(int x, int y, int n, int m) {

    visited[x][y] = true;
    if(x < n - 1 && !visited[x + 1][y])
        dfs(x + 1, y, n, m);
    if(y < m - 1 && !visited[x][y + 1])
        dfs(x, y + 1, n, m);
    if(x && !visited[x - 1][y])
        dfs(x - 1, y, n, m);
    if(y && !visited[x][y - 1])
        dfs(x, y - 1, n, m);
}

void solve_easy_version(int n, int m, int k) {

    for(int i = 0; i < k; i++) {
        int x, y;
        cin >> x >> y;
        x--;
        y--;

        visited[x][y] = true;
    }

    int ans = 0;
    for(int i = 0; i < n; i++)
        for(int j = 0; j < m; j++)
            if(!visited[i][j])
                dfs(i, j, n, m), ans++;
    cout << ans << endl;
}

int main() {

    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);

    int n, m, k;
    cin >> n >> m >> k;

    solve_easy_version(n, m, k);
    return 0;
}