#include <bits/stdc++.h>

#define mp make_pair
#define MAXN_SMALL 1010

using namespace std;

bool visited[MAXN_SMALL][MAXN_SMALL];

void dfs(int srcx, int srcy, int n, int m) {

    stack< pair<int, int> > s;
    s.push(mp(srcx, srcy));
    visited[srcx][srcy] = true;

    while(!s.empty()) {
        int x, y;
        tie(x, y) = s.top();
        s.pop();

        if(x < n - 1 && !visited[x + 1][y]) {
            s.push(mp(x + 1, y));
            visited[x + 1][y] = true;
        }
        if(y < m - 1 && !visited[x][y + 1]) {
            s.push(mp(x, y + 1));
            visited[x][y + 1] = true;
        }
        if(x && !visited[x - 1][y]) {
            s.push(mp(x - 1, y));
            visited[x - 1][y] = true;
        }
        if(y && !visited[x][y - 1]) {
            s.push(mp(x, y - 1));
            visited[x][y - 1] = true;
        }
    }
}

void solve_easy_version(int n, int m, int k) {

    for(int i = 0; i < k; i++) {
        int x, y;
        cin >> x >> y;
        x--;
        y--;

        visited[x][y] = true;
    }

    int ans = 0;
    for(int i = 0; i < n; i++)
        for(int j = 0; j < m; j++)
            if(!visited[i][j])
                dfs(i, j, n, m), ans++;
    cout << ans << endl;
}

int main() {

    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);

    int n, m, k;
    cin >> n >> m >> k;

    solve_easy_version(n, m, k);
    return 0;
}