#include <iostream>
#include <vector>

unsigned long long curr = 1;

void color(std::vector<std::vector<unsigned long long>> *table, unsigned long long i, unsigned long long j, unsigned long long depth = 0)
{
    if (table->at(i).at(j) != 0)
    {
        return;
    }
    else
    {
        table->at(i).at(j) = curr;
        for (unsigned long long k : { i - 1, i + 1 })
        {
            if (k < 0 || k >= table->size())
            {
                continue;
            }

            color(table, k, j, depth + 1);
        }

        for (unsigned long long k : { j - 1, j + 1 })
        {
            if (k < 0 || k >= table->at(i).size())
            {
                continue;
            }

            color(table, i, k, depth + 1);
        }
    }

    if (depth == 0)
    {
        curr++;
    }
}

int main()
{
    unsigned long long n, m, k;
    std::cin >> n >> m >> k;

    std::vector<std::vector<unsigned long long>> table(n);
    for (unsigned long long i = 0; i < n; i++)
    {
        table[i].assign(m, 0);
    }

    for (unsigned long long i = 0; i < k; i++)
    {
        unsigned long long x, y;
        std::cin >> x >> y;

        table[x - 1][y - 1] = -1;
    }

    for (unsigned long long i = 0; i < n; i++)
    {
        for (unsigned long long j = 0; j < m; j++)
        {
            color(&table, i, j);
        }
    }

    std::cout << curr - 1;

    return 0;
}