#include <iostream>
#include <algorithm>
#include <vector>
#define max_check 2000
using namespace std;

int broj_kol_trojki(int n)
{
	return (pow(n, 3) - 3 * pow(n, 2) + 2 * n) / 6;
}

int nadji_resenje(int rhs)
{
	for (size_t i = 3; i <= max_check; i++)
	{
		if (broj_kol_trojki(i) > rhs)
			return i - 1;
	}
}

int broj_tacaka(int potrebno_kolinearnih)
{
	return nadji_resenje(potrebno_kolinearnih);
}
struct tacka
{
	int x, y;
};

int main()
{
	ios::sync_with_stdio(false);
	cin.tie(0);
	int tx = 0, ty = 0;
	int broj_kolinearnih;
	cin >> broj_kolinearnih;
	vector<tacka> tacke;
	while (broj_kolinearnih > 0)
	{
		int za_smestanje = broj_tacaka(broj_kolinearnih);
		broj_kolinearnih -= broj_kol_trojki(za_smestanje);
		for (size_t i = 0; i < za_smestanje; i++)
		{
			tacke.push_back(tacka{ tx,ty });
			tx++;
		}
		ty++;
	}
	cout << tacke.size() <<"\n";
	for (tacka t: tacke)
	{
		cout << t.x << " " << t.y << "\n";
	}
	return 0;
}