#include <stdio.h>
#include <map>
#include <unordered_set>

int n;
int m;

int cnt;

std::map<int, std::unordered_set<int>> adj;

int ctn(int  x, int y) {
    return (m*(y))+x;
}

void addn(int here, int temp) {
    adj[here].insert(temp);
    adj[temp].insert(here);
    return;
}

void dfs(int v, bool visited[])
{
    visited[v] = true;


    for (const int& elem: adj[v]) {
            if(!visited[elem]) {
                dfs(elem, visited);
            }
        }
}


void counter()
{
    int size = adj.size();

    bool *visited = new bool[size];
    for(int v = 0; v < size; v++)
        visited[v] = false;


    for (int v=0; v<size; v++)
    {
        if(adj.find(v) == adj.end()) continue;
        if (visited[v] == false)
        {

            dfs(v, visited);

            cnt++;
        }
    }
}

int main()
{

    int k;

    scanf("%d %d %d", &n, &m, &k);

    for(int y  = 0; y <   m ; y++) {
        for(int x  = 0; x <  n ; x++) {
            int here = ctn(x, y);

            if(x+1 < m) {
                int temp = ctn(x+1, y);
                addn(here, temp);
            }

            if(x-1 >= 0) {
                int temp = ctn(x-1, y);
                addn(here, temp);
            }

            if(y+1 < n) {
                int temp = ctn(x, y+1);
                addn(here, temp);
            }

            if(y-1 >= 0) {
                int temp = ctn(x, y-1);
                addn(here, temp);
            }

        }
    }

    for(int i = 0; i < k; i++) {

        int x;
        int y;

        scanf("%d %d", &y, &x);

        x=x-1;
        y=y-1;

        int tnum = ctn(x, y);


        std::unordered_set<int> nodes  =  adj[tnum];
        for (const int& elem: nodes) {
            adj[elem].erase(tnum);
        }

        adj.erase(tnum);
    }

    counter();

    printf("%d", cnt);

    return 0;
}