#include <bits/stdc++.h>
using namespace std;

long n, m;

vector<vector<int>> wall;
vector<vector<bool>> visited;

bool isSafe(int row, int col) {
    return (row >= 0) && (row < n) && (col >= 0) && (col < m) && (wall[row][col] && !visited[row][col]);
}

void visitCel(int row, int col) {
    visited[row][col] = true;

    //Up
    if (isSafe(row - 1, col + 0))
        visitCel(row - 1, col + 0);

    //Left
    if (isSafe(row + 0, col - 1))
        visitCel(row + 0, col - 1);

    //Right
    if (isSafe(row + 0, col + 1))
        visitCel(row + 0, col + 1);

    //Down
    if (isSafe(row + 1, col + 0))
        visitCel(row + 1, col + 0);
}

int main()
{

    long k;
    scanf("%ld %ld %ld", &n, &m, &k);

    wall.resize(m, vector<int>(n, 1));

    for(long i=0; i<k; i++) {
        long x,y;
        scanf("%ld %ld", &x, &y);

        wall[x-1][y-1] = 0;
    }

    visited.resize(m, vector<bool>(n, false));

    long numberOfColors = 0;
    for (long i = 0; i < n; i++)
        for (long j = 0; j < m; j++)

            if (wall[i][j] && !visited[i][j]) {
                visitCel(i, j);

                ++numberOfColors;
            }

    printf("%ld", numberOfColors);

    return 0;
}