#include <cstdio>
#include <queue>
#include <cstdlib>

using namespace std;

struct Polje {
	bool colored;
	long color, i, j;
};

long n, m, k, broj = 0;

void printMap(Polje** mapa, long n, long m) {
	printf("\n");
	for (long i = 0; i < n; i++) {
		for (long j = 0; j < m; j++) {
			printf("%d  ", mapa[i][j].color);
		}
		printf("\n");
	}
}

void bfs(long i, long j, Polje** mapa) {
	queue<Polje> q;
	q.push(mapa[i][j]);
	mapa[i][j].color = ++broj;
	mapa[i][j].colored = true;
	while (!q.empty()) {
		Polje p = q.back();
		q.pop();
		if (p.i + 1 < n && !mapa[p.i + 1][p.j].colored) {
			mapa[p.i + 1][p.j].colored = true;
			mapa[p.i + 1][p.j].color = broj;
			q.push(mapa[p.i + 1][p.j]);
		}
		if (p.i - 1 >= 0 && !mapa[p.i - 1][p.j].colored) {
			mapa[p.i - 1][p.j].colored = true;
			mapa[p.i - 1][p.j].color = broj;
			q.push(mapa[p.i - 1][p.j]);
		}
		if (p.j - 1 >= 0 && !mapa[p.i][p.j - 1].colored) {
			mapa[p.i][p.j - 1].colored = true;
			mapa[p.i][p.j - 1].color = broj;
			q.push(mapa[p.i][p.j - 1]);
		}
		if (p.j + 1 < m && !mapa[p.i][p.j + 1].colored) {
			mapa[p.i][p.j + 1].colored = true;
			mapa[p.i][p.j + 1].color = broj;
			q.push(mapa[p.i][p.j + 1]);
		}
	}
}

int main() {
	scanf("%li%li%li", &n, &m, &k);
	Polje **mapa = (Polje**)malloc(n * sizeof(Polje*));
	for (long i = 0; i < n; i++)
		mapa[i] = (Polje*)malloc(m * sizeof(Polje));

	for (long i = 0; i < n; i++)
		for (long j = 0; j < m; j++) {
			mapa[i][j].i = i; mapa[i][j].j = j;
			mapa[i][j].colored = false;
			mapa[i][j].color = -1;
		}

	for (long c = 0; c < k; c++) {
		long i, j;
		scanf("%li%li", &i, &j);
		mapa[--i][--j].colored = true;
		mapa[i][j].color = 0;
	}

	for (long i = 0; i < n; i++) 
		for (long j = 0; j < m; j++) 
			if (!mapa[i][j].colored) 
				bfs(i, j, mapa);
	printf("%li", broj);
	return 0;
}