#include <bits/stdc++.h>
using namespace std;

int R, C;

bool isSafe(vector< vector<int> >& mat, int i, int j, vector< vector<bool> >& vis)
{
    return (i >= 0) && (i < R) &&
           (j >= 0) && (j < C) &&
           (mat[i][j] && !vis[i][j]);
}

void BFS(vector< vector<int> >& mat, vector< vector<bool> >& vis, int si, int sj)
{
    int row[] = { -1, 0, 0, 1 };
    int col[] = { 0, -1, 1, 0 };

    queue<pair<int, int> > q;
    q.push(make_pair(si, sj));
    vis[si][sj] = true;

    while (!q.empty()) {

        int i = q.front().first;
        int j = q.front().second;
        q.pop();

        for (int k = 0; k < 4; k++) {
            if (isSafe(mat, i + row[k], j + col[k], vis)) {
                vis[i + row[k]][j + col[k]] = true;
                q.push(make_pair(i + row[k], j + col[k]));
            }
        }
    }
}

int countIslands(vector< vector<int> >& mat)
{
    vector<bool> sabac(C, 0);
    vector< vector<bool> > vis(R, sabac);


    int res = 0;
    for (int i = 0; i < R; i++) {
        for (int j = 0; j < C; j++) {
            if (mat[i][j] && !vis[i][j]) {
                BFS(mat, vis, i, j);
                res++;
            }
        }
    }

    return res;
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0); cout.tie(0);

    int K, x, y;
    cin>>R>>C>>K;
    vector<int> beograd(C, 1);
    vector< vector<int> > mat(R, beograd);
    for(int i=0; i<K; i++){
        cin>>x>>y;
        mat[x-1][y-1]=0;
    }

    cout << countIslands(mat);

    return 0;
}