using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace petlja_1_2020_3
{
    class Komsija
    {
        public int pozicija { get; set; }
        public Boolean jeMilos { get; set; }

        public Komsija(int pos, bool milos)
        {
            pozicija = pos;
            jeMilos = milos;
        }

        public Komsija(Komsija kom)
        {
            pozicija = kom.pozicija;
            jeMilos = kom.jeMilos;
        }
    }

    class Program
    {
        public static List<Komsija> komsije = new List<Komsija>();
        public static int iMilosa;
        public static bool uklonjenDesni = false;
        public static bool uklonjenLevi = false;
        public static int pomeriZa;

        static void Main(string[] args)
        {
            int brojKomsija;
            int pozicijaMilosa;
            int putMilosa = 0;
            string[] s = Console.ReadLine().Split();
            brojKomsija = int.Parse(s[0]);
            pozicijaMilosa = int.Parse(s[1]);
            s = Console.ReadLine().Split();
            for (int i = 0; i < brojKomsija; i++)
            {
                komsije.Add(new Komsija(int.Parse(s[i]), false));
            }
            komsije.Add(new Komsija(pozicijaMilosa, true));
            Sortiraj(komsije, 0, komsije.Count - 1);

            while (komsije.Count > 1)
            {
                /*foreach (Komsija k in komsije)
                {
                    Console.WriteLine(k.pozicija + " " + k.jeMilos);
                }*/
                //Console.WriteLine("Poz milosa: " + iMilosa);
                int najblizi = GdeJeNajblizi();
                //Console.WriteLine("Najblizi: " + najblizi);
                komsije.RemoveAt(najblizi);
                if (uklonjenLevi)
                {
                    iMilosa--;
                    komsije[iMilosa].pozicija -= pomeriZa;
                    putMilosa += pomeriZa;
                }
                if (uklonjenDesni)
                {
                    komsije[iMilosa].pozicija += pomeriZa;
                    putMilosa += pomeriZa;
                }
                //Console.WriteLine("Uklonjen! Put milosa: " + putMilosa);
            }

            Console.WriteLine(putMilosa);
        }

        static int GdeJeNajblizi()
        {
            if (iMilosa - 1 < 0) // nema nikog levo
            {
                int daljina = Math.Abs(komsije[iMilosa + 1].pozicija - komsije[iMilosa].pozicija);
                uklonjenDesni = true;
                uklonjenLevi = false;
                pomeriZa = daljina;
                return iMilosa + 1;
            }
            else if (iMilosa + 1 >= komsije.Count) // nema nikog desno
            {
                int daljina = Math.Abs(komsije[iMilosa - 1].pozicija - komsije[iMilosa].pozicija);
                uklonjenLevi = true;
                uklonjenDesni = false;
                pomeriZa = daljina;
                return iMilosa - 1;
            }
            //normalna situacija
            int daljinaOdLevog = Math.Abs(komsije[iMilosa - 1].pozicija - komsije[iMilosa].pozicija);
            int daljinaOdDesnog = Math.Abs(komsije[iMilosa + 1].pozicija - komsije[iMilosa].pozicija);
            if (daljinaOdLevog < daljinaOdDesnog)
            {
                uklonjenLevi = true;
                uklonjenDesni = false;
                pomeriZa = daljinaOdLevog;
                return iMilosa - 1;
            }
            else
            {
                uklonjenDesni = true;
                uklonjenLevi = false;
                pomeriZa = daljinaOdDesnog;
                return iMilosa + 1;
            }
        }

        private static void Sortiraj(List<Komsija> komsije, int levi, int desni)
        {
            if (levi < desni)
            {
                int pivot = Podeli(komsije, levi, desni);
                if (pivot > 1)
                {
                    Sortiraj(komsije, levi, pivot - 1);
                }
                if (pivot + 1 < desni)
                {
                    Sortiraj(komsije, pivot + 1, desni);
                }
            }
        }

        private static int Podeli(List<Komsija> komsije, int levi, int desni)
        {
            int pivot = komsije[levi].pozicija;
            while (true)
            {
                while (komsije[levi].pozicija < pivot)
                {
                    levi++;
                }
                while (komsije[desni].pozicija > pivot)
                {
                    desni--;
                }
                if (levi < desni)
                {
                    if (komsije[levi] == komsije[desni]) return desni;
                    int temp = komsije[levi].pozicija;
                    bool temp2 = komsije[levi].jeMilos;
                    komsije[levi].pozicija = komsije[desni].pozicija;
                    komsije[levi].jeMilos = komsije[desni].jeMilos;
                    komsije[desni].pozicija = temp;
                    komsije[desni].jeMilos = temp2;
                    if (komsije[levi].jeMilos)
                        iMilosa = levi;
                    if (komsije[desni].jeMilos)
                        iMilosa = desni;
                }
                else
                {
                    return desni;
                }
            }
        }
    }
}
/*
?????? 1
????
2 1
4 7
?????
6
?????? 2
????
3 4
3 7 9
?????
7


*/