// Bezbedna podmatrica

#include <cstdio>
#include <array>
#include <cmath>
#include <utility>

constexpr uint32_t N = 1000;
constexpr uint32_t M = 1000;

uint32_t obim(uint32_t x, uint32_t y, uint32_t z, uint32_t t)
{
    if (x == z && y == t)
        return 4;
    return 2 * (std::abs((int64_t)x - (int64_t)z) + std::abs((int64_t)y - (int64_t)t));
}

int main()
{
    uint32_t n, m, a, b;
    // std::array<uint32_t, N * M> polje;
    uint32_t polje[N * M];

    std::scanf("%u %u %u %u", &n, &m, &a, &b);

    for (uint32_t i = 0; i < n; ++i) {
        for (uint32_t j = 0; j < m; ++j) {
            std::scanf("%u", &polje[i * m + j]);
        }
    }
    
    // Bezbednost polja
    auto bp = polje[0] + polje[m * n - 1] + obim(0, 0, n, m);

    // Bezbednost kuce
    auto bk = 2 * polje[(a - 1) * m + (b - 1)] + obim(a, b, a, b);

    printf("%d\n", std::max(bp, bk)); 
}