// Dobitni Listic

#include <cstdio>
#include <cstdint>
#include <array>
#include <cmath>
#include <utility>

constexpr uint32_t N = 100'000;

uint64_t nzd(uint64_t x, uint64_t y)
{
    auto a = std::min(x, y);
    uint64_t curr = 1;
    for (uint64_t i = 2; i <= a; ++i)
        if (x % i == 0 && y % i == 0)
            curr = i;
    return curr;
}

uint64_t nadji_izmedju(std::array<uint32_t, N>& arr, uint32_t i)
{
    uint32_t x = arr[i];
    auto generisi_delioce_prvog = [k = 2, x]() mutable {
        if (x == 1)
            return x;
        while (x % k) ++k;
        x /= k;
        return (uint32_t)k;
    };

    auto n = arr[i + 1];
    auto generisi_delioce_drugog = [k = 2, n]() mutable {
        if (n == 1)
            return n;
        while (n % k) ++k;
        n /= k;
        return (uint32_t)k;
    };

    uint64_t p = 1;
    auto prvi = generisi_delioce_prvog();
    auto drugi = generisi_delioce_drugog();
    while (prvi != 1 || drugi != 1)
    {
        if (prvi == drugi)
            p *= prvi;
        else
            p *= prvi * drugi;
        prvi = generisi_delioce_prvog();
        drugi = generisi_delioce_drugog();
    }
    
    return p;
}

int main()
{
    uint32_t n;
    std::array<uint32_t, N> aljoha;
    std::array<uint64_t, N> konacni;

    scanf("%u", &n);
    for (uint32_t i = 0; i < n - 1; ++i)
        scanf("%u", &aljoha[i]); 

    konacni[0] = aljoha[0];
    konacni[n - 1] = aljoha[n - 2];
    for (uint32_t i = 0; i < n - 2; ++i) 
    {
        konacni[i + 1] = nadji_izmedju(aljoha, i);
        auto x = nzd(konacni[i], konacni[i + 1]);
        if (x > aljoha[i])
        {
            std::puts("-1");
            return 0;
        }
    }
    
    for (uint32_t i = 0; i < n; ++i)
        std::printf("%llu ", konacni[i]);
    std::puts("");
} 