#include <bits/stdc++.h>
using namespace std;

void swap_index(long long* a, long long* b) {
    long long temp = *a;
    *a = *b;
    *b = temp;
}

int main() {
    ios_base::sync_with_stdio(false);
    long long n, m, k;
    cin >> n >> m >> k;
    long long arr[n];

    for (long long i = 0; i < n; i++) {
        arr[i] = i + 1; // starting from 1, not 0
    }

    unordered_map<long long, long long> susp;

    for (long long _m = 0; _m < m; _m++) {
        long long a, b;
        cin >> a >> b;
        swap_index(&arr[a - 1], &arr[b - 1]);
/*
        cout << "[1] - BEFORE INSERTING:\n";
        for (auto it = susp.begin(); it != susp.end(); it++) {
            cout << "(" << it->first << ", " << it->second << ")\n";
        }
        cout << endl;
*/
        /*
        Insert the swapped student and his pair into the suspicious map.
        I need to remove each element if it exists and override because
        maps won't override an existing key's value, which is niggerlicious.
        */

        auto p = susp.find(arr[a - 1]);
        if (p != susp.end())
            susp.erase(arr[a - 1]);

        susp.insert(pair<long long, long long>(arr[a - 1], a));

        p = susp.find(arr[b - 1]);
        if (p != susp.end())
            susp.erase(arr[b - 1]);

        susp.insert(pair<long long, long long>(arr[b - 1], b));
/*
        cout << "Inserted: (" << arr[a-1] << ", " << a << ") and (" << arr[b-1] << ", " << b << ")\n";
*/
        /*
        All of the non-suspicious students are removed.
        We only check for the freshly swapped pairs,
        because the other ones stay as-is so there's no need.
        */
/*
        cout << "[2] - BEFORE REMOVING:\n";
        for (auto it = susp.begin(); it != susp.end(); it++) {
            cout << "(" << it->first << ", " << it->second << ")\n";
        }
        cout << endl;
*/
        p = susp.find(arr[a - 1]);

        if (p != susp.end()) { /* No need for this but just in case. */
            long long diff = abs(p->first - p->second);

            if (diff <= k) {
                susp.erase(arr[a - 1]);
//               cout << "Removed: (" << arr[a-1] << ", " << a << ")\n";
            }
        }

        p = susp.find(arr[b - 1]);

        if (p != susp.end()) { /* No need for this but just in case. */
            long long diff = abs(p->first - p->second);

            if (diff <= k) {
                susp.erase(arr[b - 1]);
//                cout << "Removed: (" << arr[b-1] << ", " << b << ")\n";
            }
        }

/*
        cout << "[3] - AFTER REMOVING:\n";
        for (auto it = susp.begin(); it != susp.end(); it++) {
            cout << "(" << it->first << ", " << it->second << ")\n";
        }
*/
        /*
        If ANY of the students remain in the map, it means that
        a suspicious student exists, so Pierre can can frown :-)
        */

        if (susp.empty()) {
            cout << "0\n";
        } else {
            cout << "1\n";
        }
    }

    return 0;
}


/*

BRUTE FORCE SOLUTION O(mn)

for (int _m = 0; _m < m; _m++) {
    int a, b;
    cin >> a >> b;

    bool found = false;

    swap_index(&arr[a - 1], &arr[b - 1]);

    for (int i = 0; i < n; i++) {
        int val = arr[i];
        int pos = i + 1;

        int delta = abs(val - pos);

        if (delta > k) {
            found = true;
            break;
        }
    }

    if (found)
        cout << "1\n";
    else
        cout << "0\n";
}

*/
