#include <bits/stdc++.h>

using namespace std;

struct Takmicar
{
    int N;
    int i;
    int j;

    Takmicar()
    {
        N = -1;
        i = -1;
        j = -1;
    }

    Takmicar(int N, int i, int j)
    {
        this->N = N;
        this->i = i;
        this->j = j;
    }
};

struct Zamena
{
    int Ai;
    int Bi;

    Zamena()
    {
        Ai = -1;
        Bi = -1;
    }

    Zamena(int Ai, int Bi)
    {
        this->Ai = Ai;
        this->Bi = Bi;
    }
};

int main()
{
    // IO optimization
    cin.tie(NULL);
    ios_base::sync_with_stdio(false);

    // Input and basic processing
    int N, M, K;
    cin >> N >> M >> K;
    Takmicar takmicari[N];
    Zamena zamenePozicija[M];
    for(int i = 0; i < M; ++i)
    {
        zamenePozicija[i] = Zamena();
        cin >> zamenePozicija[i].Ai >> zamenePozicija[i].Bi;
    }
    for(int i = 0; i < N; ++i)
    {
        takmicari[i] = Takmicar(i+1, i+1, i+1);
    }

    // Output computation
    for(int i = 0; i < M; ++i)
    {
        int Ai = zamenePozicija[i].Ai;
        int Bi = zamenePozicija[i].Bi;

        // Searching for competitors.
        Takmicar *A, *B;
        for(int j = 0; j < N; ++j)
        {
            if(takmicari[j].N == Ai)
            {
                A = &takmicari[j];
            }
            else if (takmicari[j].N == Bi)
            {
                B = &takmicari[j];
            }
        }

        // Switching seats
        if(A || B)
        {
            int t = A->j;
            A->j = B->j;
            B->j = t;
        }
        else
        {
            continue;
        }

        // Searching for suspicious positions.
        bool sumnjivo = false;
        for(int j = 0; j < N; ++j)
        {
            int l = abs(takmicari[j].i - takmicari[j].j);
            if(l > K)
            {
                cout << "1\n";
                sumnjivo = true;
                break;
            }
        }
        if(!sumnjivo)
            cout << "0\n";
    }

    return 0;
}
