#include <iostream>
#include <vector>
#include <unordered_map>
#include <algorithm>
#include <iterator>
using namespace std;

long long max_broj = 0;

vector<long long> nz_hintova;
vector< unordered_map<long long, long long> > sito;
vector<long long> niz;
long long n;

void Unos()
{
    cin >> n;
    n--;

    for(long long i = 0; i < n; i++)
    {
        long long unos;
        cin >> unos;
        if(unos > max_broj)
            max_broj = unos;
        nz_hintova.push_back(unos);
    }
}

void EratostenovoSito()
{
    for(int i = 0; i <= max_broj; i++)
    {
        unordered_map<long long, long long> nova_mapa;
        sito.push_back(nova_mapa);
    }

    for(long long broj = 2; broj <= max_broj; broj++)
    {
        if (sito[broj].size() == 0)
        {
            for(long long i = broj; i <= max_broj; i += broj)
            {
                long long broj_i = i;
                while(broj_i % broj == 0)
                {
                    broj_i /= broj;
                    sito[i][broj]++;
                }
            }
        }
    }
}

void NapraviNiz()
{
    for(long long i = 0; i < n + 1; i++)
    {
        long long broj_niza = 1;
        unordered_map<long long, long long> faktori;

        if(i > 0)
            for(unordered_map<long long, long long>::iterator itr = sito[nz_hintova[i - 1]].begin(); itr != sito[nz_hintova[i - 1]].end(); itr++)
            {
                if(faktori[(*itr).first] < (*itr).second)
                        faktori[(*itr).first] = (*itr).second;
            }

        if(i < n)
            for(unordered_map<long long, long long>::iterator itr = sito[nz_hintova[i]].begin(); itr != sito[nz_hintova[i]].end(); itr++)
            {
                if(faktori[(*itr).first] < (*itr).second)
                        faktori[(*itr).first] = (*itr).second;
            }

        for(unordered_map<long long, long long>::iterator itr = faktori.begin(); itr != faktori.end(); itr++)
            {
                broj_niza *= (*itr).first * (*itr).second;
            }
        niz.push_back(broj_niza);
    }
}

void Ispis()
{
    for(long long i = 0; i < n + 1; i++)
        {
            cout << niz[i] << " ";
        }
}

bool ProveriNiz()
{
    long long prosli_element = -1;
    for(long long i = 0; i < n + 1; i++)
        {
            if(niz[i] == prosli_element && nz_hintova[i - 1] != niz[i])
                return false;
            if (niz[i] > 1000000000000000000)
                return false;
            prosli_element = niz[i];
        }
    return true;
}

int main()
{
    ios::sync_with_stdio(false);
    cin.tie(0);

    Unos();

    EratostenovoSito();

    NapraviNiz();

    if(!ProveriNiz())
        {
            cout << -1;
        }
    else
        {
            Ispis();
        }
}
