#include <bits/stdc++.h>

using namespace std;


typedef vector<int> vi;
typedef queue<int> qi;
typedef set<int> si;


// global variables:
int N, M, K;  // M - # of swaps
vi COMPUTERS;

si MEMO;  // keep track of those which are not Ok

// functions:
void input();
bool Solve(int i, int j);



int main()
{
    //freopen("input.txt", "r", stdin);

    input();

    int i, j;
    while (M--) {
        scanf("%d %d", &i, &j);
        bool did_frown = Solve(i, j);

        printf("%c\n", did_frown ? '1' : '0');
    }

    return 0;
}



bool Solve(int i, int j) {
    bool out = false;

    // do a swap
    swap(COMPUTERS[i], COMPUTERS[j]);

    bool i_fine = true;
    if (abs(i - COMPUTERS[i]) > K) i_fine = false;

    bool j_fine = true;
    if (abs(j - COMPUTERS[j]) > K) j_fine = false;



    // update new indices in memo

    if (!i_fine) {  // invalid
        MEMO.insert(i);  // there is no repetition in set
    } else {  // it is now valid if it was ever invalid
        auto memo_i = MEMO.find(i);
        if (memo_i != MEMO.end()) {  // it is now valid
            MEMO.erase(i);
        }
    }

    if (!j_fine) {
        MEMO.insert(j);  // there is no repetition in set
    } else {  // it is now valid if it was ever invalid
        auto memo_j = MEMO.find(j);
        if (memo_j != MEMO.end()) {  // it is now valid
            MEMO.erase(j);
        }
    }


    // insert into set if necessary
    if (MEMO.size()) out = true;

    return out;
}


void input() {
    scanf("%d %d %d", &N, &M, &K);
    //cin >> N >> M >> K;
    // reallocate space:
    COMPUTERS.assign(N + 1, 0);  // 1 - indexed
    for (int i = 1; i <= N; ++i) {
        COMPUTERS[i] = i;
    }

    //printf("%d %d %d\n", N, M, K);
}
