#include <iostream>
#include <vector>
#include <algorithm>

//#define DEBUG

using namespace std;

typedef long long ll;

struct magija{
    int atk;
    bool special;
    bool operator <(magija m){
        return atk < m.atk;
    }
    bool operator >(magija m){
        return atk > m.atk;
    }
};

void use(vector<magija>& vec);

#ifdef DEBUG
void printVec(vector<magija>& vec){
    for(int i = 0; i < vec.size(); ++i){
        cout << vec[i].atk;
        if(vec[i].special){
            cout << "*";
        }
        cout << " ";
    }
    cout << endl;
}
#endif // DEBUG

int main()
{
    ios::sync_with_stdio(false);
    cin.tie(0);

    ll e;
    int n;
    cin >> n >> e;
    vector<magija> vec(2*n);
    for(int i = 0; i < n; ++i){
        cin >> vec[i].atk;
        vec[i].special = false;
    }
    for(int i = 0; i < n; ++i){
        cin >> vec[n+i].atk;
        vec[n+i].special = true;
    }
    sort(vec.begin(), vec.end());
#ifdef DEBUG
    printVec(vec);
#endif // DEBUG
    ll s = 0;
    while(e > 0){
        ++s;
        e -= vec[vec.size()-1].atk;
        use(vec);
#ifdef DEBUG
        cout << "Yeti HP = " << e << endl;
        printVec(vec);
#endif // DEBUG
    }
    cout << s << endl;
    return 0;
}

void use(vector<magija>& vec){
    magija used = vec[vec.size()-1];
    vec.erase(vec.end()-1);
    if(used.special){
        return;
    }
    used.atk = used.atk/2;
    int min = 0;
    int max = vec.size()-1;
    int mid = (min+max)/2;
    while(true){
        if(used.atk == vec[mid].atk || max-min < 2){
            break;
        }
        if(used > vec[mid]){
            min = mid;
        }
        else{
            max = mid;
        }
        mid = (min+max)/2;
    }
    vec.insert(vec.begin()+mid+1, used);
}
