#include<stdio.h>
#include<iostream>
#include<vector>

#define MAX_A 35000

using ull = unsigned long long int;

int lp[MAX_A + 1];
std::vector<int> pr;

void sieve(){
    for(int i = 2; i <= MAX_A; ++i){
        if(!lp[i]){
            lp[i] = i;
            pr.push_back(i);
        }
        for(int j = 0; j < pr.size() && pr[j] <= lp[i] && i*pr[j] <= MAX_A; ++j){
            lp[i * pr[j]] = pr[j];
        }
    }
}

ull gcd(ull a, ull b){
    return b ? gcd(b, a%b) : a;
}

bool prime(int x){ return x == lp[x]; }

bool gcd_check(std::vector<int> a, std::vector<ull> l, int i){
    return (gcd(l[i-1], l[i]) == a[i-1]) && (gcd(l[i], l[i+1]) == a[i]);
}

ull new_elem(std::vector<int> a, std::vector<ull> l, int i){
    int tmp1 = l[i] / (ull)a[i-1];
    int tmp2 = l[i] / (ull)a[i];

    l[i] /= gcd(tmp1, tmp2);
    if(gcd_check(a, l, i)){
        return l[i];
    }
    return 0;
}

int main(){
    std::ios::sync_with_stdio(false);
    std::cin.tie(0);

    sieve();

    int n, tmp;
    std::vector<int> a;
    std::vector<ull> l;

    std::cin >> n;
    for(int i = 0; i < n - 1; ++i){
        std::cin >> tmp;
        a.push_back(tmp);
    }

    l.push_back(a.front());
    for(int i = 0; i < n - 2; ++i){
        l.push_back(a[i] * a[i+1]);
    }
    l.push_back(a.back());

    for(int i = 1; i < a.size(); ++i){
        l[i] = (new_elem(a, l, i) ? new_elem(a, l, i) : l[i]);
    }

    for(int i = 1; i < a.size(); ++i){
        if(!gcd_check(a, l, i)){
            std::cout << -1;
            return 0;
        }
    }

    for(int i = 0; i < l.size(); ++i){
        std::cout << l[i] << " ";
    }

    printf("\n");
    return 0;
}
