#include <bits/stdc++.h>

using namespace std;

int poljeX = 0;
int poljeO = 1;
int poljePrazno = 2;

int tabla[100][100];
char znakovi[3] = {'X', 'O', '.'};
int brX=1;

int posleXI=1;
int posleXJ=1;

int poteziX[2] = {poljeX, poljePrazno};
int poteizO[2] = {poljeO, poljePrazno};

int kretanjeI[] = {1,1,0,-1,-1,-1,0,1};
int kretanjeJ[] = {0,1,1,1,0,-1,-1,-1};

void ispis(int n) {
    for (int i=0; i<n; i++) {
        for (int j=0; j<n; j++) {
            int value = tabla[i][j];
            int znak = value == -1 ? poljePrazno : value;
            printf("%c", znakovi[znak]);
        }
        printf("\n");
    }
}

bool isSafe(int i, int j, int n) {
    if(i>=0 && i<n && j>=0 && j<n && tabla[i][j] == -1) {
        return true;
    }
    else {
        return false;
    }
}

bool popuniPolje(int a, int b, int n, int potrebnoUz, int potrebnoPot, int brUz, int brPot, int znak) {

    if(brUz==potrebnoUz && brPot == 0) {
        posleXI=a+1;
        posleXJ=b+1;
        return 1;
    }

    if(brPot > potrebnoPot || brUz > potrebnoUz || brPot<0) {
        return 0;
    }

    for (int i=0; i<8; i++) {
        int nextStepI = a+kretanjeI[i];
        int nextStepJ = b+kretanjeJ[i];

        if(isSafe(nextStepI, nextStepJ, n)) {
            tabla[nextStepI][nextStepJ]=znak;

            if(popuniPolje(nextStepI, nextStepJ, n, potrebnoUz, potrebnoPot, brUz+1, brPot-2, poljeX)) {
                brX++;
                return 1;
            } else {
                if(popuniPolje(nextStepI, nextStepJ, n, potrebnoUz, potrebnoPot, brUz+1, brPot-2, poljePrazno)) {
                    return 1;
                } else {
                    tabla[nextStepI][nextStepJ]=-1;
                }
            }
        }

        return 0;
    }
}

int main() {

    int n, k, t;

    scanf("%d %d %d", &n, &k, &t);

    for (int i=0; i<n; i++) {
        for (int j=0; j<n; j++)
            tabla[i][j] = -1;
    }

    tabla[0][0] = poljeX;

    if (t == 1 && k == 1) {
        ispis(n);
        printf("1 1");

        return 0;
    }

    if (t < k+(k-1)) {
        printf("nemoguce");

        return 0;
    }

    popuniPolje(0, 0, n, k, t, 1, t-1, poljeX);

    int potrebno=brX-1;
    for(int i=n-1; i>=0; i--) {
        for (int j=n-1; j>=0; j--) {
            if(potrebno==0) {
                break;
            }
            tabla[i][j]=poljeO;
            potrebno--;
        }
    }

    ispis(n);
    printf("%d %d", posleXI, posleXJ);

    return 0;
}
