using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace premestanja
{
    class Takmicar
    {
        public int redniBroj { get; set; }
        public int brRacunara { get; set; }
        public bool trenutnoSumnjiv { get; set; }

        public Takmicar(int redniBroj, int brRacunara)
        {
            this.redniBroj = redniBroj;
            this.brRacunara = brRacunara;
            this.trenutnoSumnjiv = false;
        }

        public Takmicar()
        {
            brRacunara = -1;
            redniBroj = -1;
            trenutnoSumnjiv = false;
        }

    }
    class Program
    {
        static bool nekoJeSumnjiv = false;
        static int brojSumnjivih = 0;

        static bool profesorSumnja(Takmicar t1, Takmicar t2, int sumnja)
        {
            int temp = t1.brRacunara;
            t1.brRacunara = t2.brRacunara;
            t2.brRacunara = temp;
            bool vrati = false;
            if (Math.Abs(t1.brRacunara - t1.redniBroj) > sumnja)
            {
                if (!t1.trenutnoSumnjiv)
                {
                    nekoJeSumnjiv = true;
                    brojSumnjivih++;
                    t1.trenutnoSumnjiv = true;
                }
                vrati = true;
            }
            if(Math.Abs(t2.brRacunara - t2.redniBroj) > sumnja)
            {
                if (!t2.trenutnoSumnjiv)
                {
                    nekoJeSumnjiv = true;
                    brojSumnjivih++;
                    t2.trenutnoSumnjiv = true;
                }
                vrati = true;
            }
            if (vrati)
                return true;
            if (nekoJeSumnjiv)
            {
                if (t1.trenutnoSumnjiv)
                {
                    t1.trenutnoSumnjiv = false;
                    brojSumnjivih--;
                }
                if (t2.trenutnoSumnjiv)
                {
                    t2.trenutnoSumnjiv = false;
                    brojSumnjivih--;
                }
            }
            if (brojSumnjivih <= 0)
            {
                brojSumnjivih = 0;
                nekoJeSumnjiv = false;
            }
            if (nekoJeSumnjiv)
                return true;
            return false;
        }

        static void Main(string[] args)
        {
            string[] unos = Console.ReadLine().Split();
            int brTakmicara = int.Parse(unos[0]);
            int brPremestanja = int.Parse(unos[1]);
            int sumnja = int.Parse(unos[2]);
            Takmicar[] takmicari = new Takmicar[brTakmicara];
            for (int i = 0; i < brPremestanja; i++)
            {
                unos = Console.ReadLine().Split();
                int br1 = int.Parse(unos[0]);
                int br2 = int.Parse(unos[1]);
                Takmicar prvi = takmicari[br1 - 1];
                Takmicar drugi = takmicari[br2 - 1];
                if (prvi == null)
                {
                    prvi = new Takmicar(br1, br1);
                    takmicari[br1 - 1] = prvi;
                }
                if (drugi == null)
                {
                    drugi = new Takmicar(br2, br2);
                    takmicari[br2 - 1] = drugi;
                }
                if (profesorSumnja(prvi, drugi, sumnja))
                    Console.WriteLine(1);
                else
                    Console.WriteLine(0);
            }
        }
    }
}
/*
8 5 3
4 6
8 2
2 5
5 8
1 2
*/
/*
10 2 0
1 10
1 10
*/