#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;
#define ll long long
class SegmentTree
{
public:
	SegmentTree(vector<ll>* numbers);
	ll Sum(int l, int r);
	void ModifyElement(int position, ll new_value);
private:
	vector<ll> tree;
	int element_count;
};

SegmentTree::SegmentTree(vector<ll>* numbers)
{
	element_count = numbers->size();
	tree = vector<ll>(element_count * 2);
	copy(numbers->begin(), numbers->end(), tree.begin() + element_count);
	for (int i = element_count-1; i > 0; i--)
		tree[i] = tree[2 * i] + tree[2 * i + 1];
}

ll SegmentTree::Sum(int l, int r)
{
	l += element_count;
	r += element_count;
	ll sum = 0;
	while (l < r)
	{
		if (l % 2 == 1)
		{
			sum += tree[l++];
		}
		if (r % 2 == 1)
		{
			sum += tree[--r];
		}
		l /= 2;
		r /= 2;
	}
	return sum;
}

void SegmentTree::ModifyElement(int position, ll new_value)
{
	position += element_count;
	tree[position] = new_value;
	position /= 2;
	while (position > 0)
	{
		tree[position] = tree[position * 2] + tree[position * 2 + 1];
		position /= 2;
	}
}

void Smestaj(int N, int M, int Q, int* T, int* U, int* X, int* Ans)
{
	auto start_vec = vector<ll>(M, 1);
	SegmentTree segment_tree = SegmentTree(&start_vec);
	vector<int> reservations = vector<int>(N,-1);
	int answer_index = 1;
	for (int query_index = 1; query_index <= Q; query_index++)
	{
		if (T[query_index] == 1)
		{
			int person = U[query_index];
			if (reservations[person] != -1)
			{
				segment_tree.ModifyElement(reservations[person], 1);
			}
			reservations[person] = X[query_index] - 1;
			segment_tree.ModifyElement(reservations[person], 0);
		}
		else
		{
			int query_person = U[query_index];
			if (reservations[query_person] == -1) //The person didn't reserve a room
			{
				if (segment_tree.Sum(0,M) < query_person)
				{
					Ans[answer_index++] = -1;
				}
				else
				{
					int l = 0, r = M;
					while (l < r)
					{
						int mid = (l + r) / 2;
						ll sum = segment_tree.Sum(0, mid);
						if (sum == query_person)
						{
							Ans[answer_index++] = mid;
							break;
						}
						if (sum > query_person)
						{
							r = mid;
						}
						else
						{
							l = mid;
						}
					}
				}

			}
			else
			{
				int r = reservations[query_person]+1;
				int l = 0;
				if (segment_tree.Sum(0,r) == 0)
				{
					Ans[answer_index++] = r;
					continue;
				}
				while (l < r)
				{
					int mid = (l + r) / 2;
					ll sum = segment_tree.Sum(0, mid);
					if (sum == 1)
					{
						Ans[answer_index++] = mid+1;
						break;
					}
					if (sum > 1)
					{
						r = mid;
					}
					else
					{
						l = mid;
					}
				}
			}
		}
	}
}